/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.builders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.simmetrics.ListMetric;
import org.simmetrics.Metric;
import org.simmetrics.MultisetMetric;
import org.simmetrics.SetMetric;
import org.simmetrics.StringMetric;
import org.simmetrics.builders.StringMetrics;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.tokenizers.Tokenizer;
import org.simmetrics.tokenizers.Tokenizers;

public final class StringMetricBuilder {
    private StringMetricBuilder() {
    }

    public static StringMetricInitialSimplifierStep with(StringMetric metric) {
        return new CompositeStringMetricBuilder(metric);
    }

    public static CollectionMetricInitialSimplifierStep<List<String>> with(ListMetric<String> metric) {
        return new CompositeListMetricBuilder((Metric<List<String>>)metric);
    }

    public static CollectionMetricInitialSimplifierStep<Set<String>> with(SetMetric<String> metric) {
        return new CompositeSetMetricBuilder((Metric<Set<String>>)metric);
    }

    public static CollectionMetricInitialSimplifierStep<Multiset<String>> with(MultisetMetric<String> metric) {
        return new CompositeMultisetMetricBuilder((Metric<Multiset<String>>)metric);
    }

    private static final class CompositeStringMetricBuilder
    implements StringMetricSimplifierStep {
        private final Metric<String> metric;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();

        CompositeStringMetricBuilder(Metric<String> metric) {
            Preconditions.checkNotNull(metric);
            this.metric = metric;
        }

        @Override
        public StringMetric build() {
            if (this.simplifiers.isEmpty()) {
                return StringMetrics.create(this.metric);
            }
            return StringMetrics.create(this.metric, this.chainSimplifiers());
        }

        private Simplifier chainSimplifiers() {
            Simplifier simplifier = Simplifiers.chain(this.simplifiers);
            this.simplifiers.clear();
            return simplifier;
        }

        @Override
        public BuildStep cacheStrings(Cache<String, String> cache) {
            Preconditions.checkNotNull(cache);
            CachingSimplifier cachingSimplifier = new CachingSimplifier(cache, this.chainSimplifiers());
            this.simplifiers.add(cachingSimplifier);
            return this;
        }

        @Override
        public StringMetricSimplifierStep simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }
    }

    private static final class CompositeListMetricBuilder
    extends CompositeCollectionMetricBuilder<List<String>> {
        CompositeListMetricBuilder(Metric<List<String>> metric) {
            super(metric);
        }

        @Override
        StringMetric build(Metric<List<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            return StringMetrics.createForListMetric(metric, simplifier, tokenizer);
        }

        @Override
        StringMetric build(Metric<List<String>> metric, Tokenizer tokenizer) {
            return StringMetrics.createForListMetric(metric, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, List<String>> cache, Tokenizer tokenizer) {
            return new CachingListTokenizer(cache, tokenizer);
        }
    }

    private static final class CompositeSetMetricBuilder
    extends CompositeCollectionMetricBuilder<Set<String>> {
        CompositeSetMetricBuilder(Metric<Set<String>> metric) {
            super(metric);
        }

        @Override
        StringMetric build(Metric<Set<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            return StringMetrics.createForSetMetric(metric, simplifier, tokenizer);
        }

        @Override
        StringMetric build(Metric<Set<String>> metric, Tokenizer tokenizer) {
            return StringMetrics.createForSetMetric(metric, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, Set<String>> cache, Tokenizer tokenizer) {
            return new CachingSetTokenizer(cache, tokenizer);
        }
    }

    private static final class CompositeMultisetMetricBuilder
    extends CompositeCollectionMetricBuilder<Multiset<String>> {
        CompositeMultisetMetricBuilder(Metric<Multiset<String>> metric) {
            super(metric);
        }

        @Override
        StringMetric build(Metric<Multiset<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            return StringMetrics.createForMultisetMetric(metric, simplifier, tokenizer);
        }

        @Override
        StringMetric build(Metric<Multiset<String>> metric, Tokenizer tokenizer) {
            return StringMetrics.createForMultisetMetric(metric, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, Multiset<String>> cache, Tokenizer tokenizer) {
            return new CachingMultisetTokenizer(cache, tokenizer);
        }
    }

    static final class CachingListTokenizer
    implements Tokenizer {
        private final Cache<String, List<String>> cache;
        final Tokenizer tokenizer;

        CachingListTokenizer(Cache<String, List<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(final String input) {
            try {
                return (List)this.cache.get((Object)input, (Callable)new Callable<List<String>>(){

                    @Override
                    public List<String> call() {
                        return tokenizer.tokenizeToList(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CachingListTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingSetTokenizer
    implements Tokenizer {
        private final Cache<String, Set<String>> cache;
        final Tokenizer tokenizer;

        CachingSetTokenizer(Cache<String, Set<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> tokenizeToSet(final String input) {
            try {
                return (Set)this.cache.get((Object)input, (Callable)new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() {
                        return tokenizer.tokenizeToSet(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CachingSetTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingMultisetTokenizer
    implements Tokenizer {
        private final Cache<String, Multiset<String>> cache;
        final Tokenizer tokenizer;

        CachingMultisetTokenizer(Cache<String, Multiset<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Multiset<String> tokenizeToMultiset(final String input) {
            try {
                return (Multiset)this.cache.get((Object)input, (Callable)new Callable<Multiset<String>>(){

                    @Override
                    public Multiset<String> call() {
                        return tokenizer.tokenizeToMultiset(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return "CachingMultisetTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingSimplifier
    implements Simplifier {
        private final Cache<String, String> cache;
        final Simplifier simplifier;

        CachingSimplifier(Cache<String, String> cache, Simplifier simplifier) {
            this.cache = cache;
            this.simplifier = simplifier;
        }

        @Override
        public String simplify(final String input) {
            try {
                return (String)this.cache.get((Object)input, (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return simplifier.simplify(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return "CachingSimplifier [" + this.simplifier + "]";
        }
    }

    private static abstract class CompositeCollectionMetricBuilder<T extends Collection<String>>
    implements CollectionMetricSimplifierStep<T>,
    CollectionMetricTokenizerStep<T> {
        private final Metric<T> metric;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();
        private final List<Tokenizer> tokenizers = new ArrayList<Tokenizer>();

        CompositeCollectionMetricBuilder(Metric<T> metric) {
            Preconditions.checkNotNull(metric);
            this.metric = metric;
        }

        @Override
        public final StringMetric build() {
            Tokenizer tokenizer = this.chainTokenizers();
            if (this.simplifiers.isEmpty()) {
                return this.build(this.metric, tokenizer);
            }
            return this.build(this.metric, this.chainSimplifiers(), tokenizer);
        }

        abstract StringMetric build(Metric<T> var1, Simplifier var2, Tokenizer var3);

        abstract StringMetric build(Metric<T> var1, Tokenizer var2);

        @Override
        public final BuildStep cacheTokens(Cache<String, T> cache) {
            Preconditions.checkNotNull(cache);
            this.tokenizers.add(this.createCachingTokenizer(cache, this.chainTokenizers()));
            return this;
        }

        protected abstract Tokenizer createCachingTokenizer(Cache<String, T> var1, Tokenizer var2);

        @Override
        public final CollectionMetricInitialTokenizerStep<T> cacheStrings(Cache<String, String> cache) {
            Preconditions.checkNotNull(cache);
            CachingSimplifier cachingSimplifier = new CachingSimplifier(cache, this.chainSimplifiers());
            this.simplifiers.add(cachingSimplifier);
            return this;
        }

        @Override
        public final CollectionMetricSimplifierStep<T> simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }

        @Override
        public final CollectionMetricTokenizerStep<T> tokenize(Tokenizer tokenizer) {
            Preconditions.checkNotNull((Object)tokenizer);
            this.tokenizers.add(tokenizer);
            return this;
        }

        @Override
        public final CollectionMetricTokenizerStep<T> filter(Predicate<String> predicate) {
            Preconditions.checkNotNull(predicate);
            Tokenizer filter = Tokenizers.filter(this.chainTokenizers(), predicate);
            this.tokenizers.add(filter);
            return this;
        }

        @Override
        public final CollectionMetricTokenizerStep<T> transform(Function<String, String> function) {
            Preconditions.checkNotNull(function);
            Tokenizer transform = Tokenizers.transform(this.chainTokenizers(), function);
            this.tokenizers.add(transform);
            return this;
        }

        private Tokenizer chainTokenizers() {
            Tokenizer tokenizer = Tokenizers.chain(this.tokenizers);
            this.tokenizers.clear();
            return tokenizer;
        }

        private Simplifier chainSimplifiers() {
            Simplifier simplifier = Simplifiers.chain(this.simplifiers);
            this.simplifiers.clear();
            return simplifier;
        }
    }

    public static interface CollectionMetricTokenizerStep<T extends Collection<String>>
    extends BuildStep,
    CollectionMetricInitialTokenizerStep<T> {
        @Override
        public CollectionMetricTokenizerStep<T> tokenize(Tokenizer var1);

        public CollectionMetricTokenizerStep<T> filter(Predicate<String> var1);

        public CollectionMetricTokenizerStep<T> transform(Function<String, String> var1);

        public BuildStep cacheTokens(Cache<String, T> var1);

        @Override
        public StringMetric build();
    }

    public static interface CollectionMetricInitialTokenizerStep<T extends Collection<String>> {
        public CollectionMetricTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface CollectionMetricSimplifierStep<T extends Collection<String>>
    extends CollectionMetricInitialSimplifierStep<T> {
        @Override
        public CollectionMetricSimplifierStep<T> simplify(Simplifier var1);

        public CollectionMetricInitialTokenizerStep<T> cacheStrings(Cache<String, String> var1);

        @Override
        public CollectionMetricTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface CollectionMetricInitialSimplifierStep<T extends Collection<String>> {
        public CollectionMetricSimplifierStep<T> simplify(Simplifier var1);

        public CollectionMetricTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface StringMetricSimplifierStep
    extends StringMetricInitialSimplifierStep {
        @Override
        public StringMetricSimplifierStep simplify(Simplifier var1);

        public BuildStep cacheStrings(Cache<String, String> var1);

        @Override
        public StringMetric build();
    }

    public static interface StringMetricInitialSimplifierStep
    extends BuildStep {
        public StringMetricSimplifierStep simplify(Simplifier var1);

        @Override
        public StringMetric build();
    }

    public static interface BuildStep {
        public StringMetric build();
    }
}

