/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.ToStringPretty;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;

public enum SetOperator implements ASTNode,
BiPredicate<Boolean, List<Boolean>>,
ToStringPretty
{
    OVERALL((overall, __) -> overall),
    SOME((__, set) -> set.stream().anyMatch(Boolean::booleanValue)),
    EVERY((__, set) -> set.stream().allMatch(Boolean::booleanValue)),
    ONE((__, set) -> set.stream().filter(Boolean::booleanValue).count() == 1L),
    LONE((__, set) -> set.stream().filter(Boolean::booleanValue).count() <= 1L);

    private final BiPredicate<Boolean, List<Boolean>> PRED;

    private SetOperator(BiPredicate<Boolean, List<Boolean>> pred) {
        this.PRED = pred;
    }

    public static SetOperator from(String text) {
        if ((text = text.toUpperCase(Locale.ROOT)).equals("EACH")) {
            text = "EVERY";
        }
        return SetOperator.valueOf(text);
    }

    @Override
    public boolean test(Boolean overall, List<Boolean> counts) {
        return this.PRED.test(overall, counts);
    }

    public String toString() {
        return this.name().toUpperCase(Locale.ROOT);
    }
}

