/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.resourcetype.RegistryBackedResourceType;
import java.util.stream.Stream;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.IForgeRegistry;

public class SlurryResourceType
extends RegistryBackedResourceType<SlurryStack, Slurry, ISlurryHandler> {
    public static final SFMBlockCapabilityKind<ISlurryHandler> CAP = new SFMBlockCapabilityKind(CapabilityManager.get((CapabilityToken)new CapabilityToken<ISlurryHandler>(){}));

    public SlurryResourceType() {
        super(CAP);
    }

    @Override
    public long getAmount(SlurryStack stack) {
        return stack.getAmount();
    }

    @Override
    public SlurryStack getStackInSlot(ISlurryHandler handler, int slot) {
        return (SlurryStack)handler.getChemicalInTank(slot);
    }

    @Override
    public SlurryStack extract(ISlurryHandler handler, int slot, long amount, boolean simulate) {
        return (SlurryStack)handler.extractChemical(slot, amount, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(ISlurryHandler handler) {
        return handler.getTanks();
    }

    @Override
    public long getMaxStackSize(SlurryStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSizeForSlot(ISlurryHandler handler, int slot) {
        return handler.getTankCapacity(slot);
    }

    @Override
    public SlurryStack insert(ISlurryHandler handler, int slot, SlurryStack stack, boolean simulate) {
        return (SlurryStack)handler.insertChemical(slot, (ChemicalStack)stack, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public boolean isEmpty(SlurryStack stack) {
        return stack.isEmpty();
    }

    @Override
    public SlurryStack getEmptyStack() {
        return SlurryStack.EMPTY;
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof SlurryStack;
    }

    @Override
    public boolean matchesCapabilityType(Object o) {
        return o instanceof ISlurryHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(SlurryStack slurryStack) {
        return ((Slurry)slurryStack.getType()).getTags().map(TagKey::f_203868_);
    }

    @Override
    public IForgeRegistry<Slurry> getRegistry() {
        return MekanismAPI.slurryRegistry();
    }

    @Override
    public Slurry getItem(SlurryStack stack) {
        return (Slurry)stack.getType();
    }

    @Override
    public SlurryStack copy(SlurryStack stack) {
        return stack.copy();
    }

    @Override
    protected SlurryStack setCount(SlurryStack stack, long amount) {
        stack.setAmount(amount);
        return stack;
    }
}

