/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.resourcetype.RegistryBackedResourceType;
import java.util.stream.Stream;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.IForgeRegistry;

public class PigmentResourceType
extends RegistryBackedResourceType<PigmentStack, Pigment, IPigmentHandler> {
    public static final SFMBlockCapabilityKind<IPigmentHandler> CAP = new SFMBlockCapabilityKind(CapabilityManager.get((CapabilityToken)new CapabilityToken<IPigmentHandler>(){}));

    public PigmentResourceType() {
        super(CAP);
    }

    @Override
    public long getAmount(PigmentStack stack) {
        return stack.getAmount();
    }

    @Override
    public PigmentStack getStackInSlot(IPigmentHandler handler, int slot) {
        return (PigmentStack)handler.getChemicalInTank(slot);
    }

    @Override
    public PigmentStack extract(IPigmentHandler handler, int slot, long amount, boolean simulate) {
        return (PigmentStack)handler.extractChemical(slot, amount, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(IPigmentHandler handler) {
        return handler.getTanks();
    }

    @Override
    public long getMaxStackSize(PigmentStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSizeForSlot(IPigmentHandler handler, int slot) {
        return handler.getTankCapacity(slot);
    }

    @Override
    public PigmentStack insert(IPigmentHandler handler, int slot, PigmentStack stack, boolean simulate) {
        return (PigmentStack)handler.insertChemical(slot, (ChemicalStack)stack, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public boolean isEmpty(PigmentStack stack) {
        return stack.isEmpty();
    }

    @Override
    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof PigmentStack;
    }

    @Override
    public boolean matchesCapabilityType(Object o) {
        return o instanceof IPigmentHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(PigmentStack pigmentStack) {
        return ((Pigment)pigmentStack.getType()).getTags().map(TagKey::f_203868_);
    }

    @Override
    public IForgeRegistry<Pigment> getRegistry() {
        return MekanismAPI.pigmentRegistry();
    }

    @Override
    public Pigment getItem(PigmentStack stack) {
        return (Pigment)stack.getType();
    }

    @Override
    public PigmentStack copy(PigmentStack stack) {
        return stack.copy();
    }

    @Override
    protected PigmentStack setCount(PigmentStack stack, long amount) {
        stack.setAmount(amount);
        return stack;
    }
}

