/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.logging;

import ca.teamdman.sfm.common.util.SFMTranslationUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;

public record TranslatableLogEvent(Level level, Instant instant, TranslatableContents contents) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.level.name());
        buf.writeLong(this.instant.getEpochMillisecond());
        buf.writeInt(this.instant.getNanoOfMillisecond());
        SFMTranslationUtils.encodeTranslation(this.contents, buf);
    }

    public static TranslatableLogEvent decode(FriendlyByteBuf buf) {
        Level level = Level.getLevel((String)buf.m_130277_());
        long epochMillisecond = buf.readLong();
        int epochNano = buf.readInt();
        TranslatableContents contents = SFMTranslationUtils.decodeTranslation(buf);
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(epochMillisecond, epochNano);
        return new TranslatableLogEvent(level, (Instant)instant, contents);
    }
}

