/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.recipe.NotContainer;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintingPressBlockEntity
extends BlockEntity
implements NotContainer {
    private final ItemStackHandler FORM = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.m_6596_();
            if (PrintingPressBlockEntity.this.f_58857_ != null) {
                PrintingPressBlockEntity.this.f_58857_.m_7260_(PrintingPressBlockEntity.this.f_58858_, PrintingPressBlockEntity.this.m_58900_(), PrintingPressBlockEntity.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == SFMItems.FORM_ITEM.get();
        }
    };
    private final ItemStackHandler INK = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.m_6596_();
            if (PrintingPressBlockEntity.this.f_58857_ != null) {
                PrintingPressBlockEntity.this.f_58857_.m_7260_(PrintingPressBlockEntity.this.f_58858_, PrintingPressBlockEntity.this.m_58900_(), PrintingPressBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (PrintingPressBlockEntity.this.m_58904_() == null) {
                return false;
            }
            return PrintingPressBlockEntity.this.m_58904_().m_7465_().m_44013_((RecipeType)SFMRecipeTypes.PRINTING_PRESS.get()).stream().anyMatch(r -> r.INK.test(stack));
        }
    };
    private final ItemStackHandler PAPER = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PrintingPressBlockEntity.this.m_6596_();
            if (PrintingPressBlockEntity.this.f_58857_ != null) {
                PrintingPressBlockEntity.this.f_58857_.m_7260_(PrintingPressBlockEntity.this.f_58858_, PrintingPressBlockEntity.this.m_58900_(), PrintingPressBlockEntity.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (PrintingPressBlockEntity.this.m_58904_() == null) {
                return false;
            }
            return PrintingPressBlockEntity.this.m_58904_().m_7465_().m_44013_((RecipeType)SFMRecipeTypes.PRINTING_PRESS.get()).stream().anyMatch(r -> r.PAPER.test(stack));
        }
    };
    private final LazyOptional<IItemHandler> ITEMS_CAPABILITY = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.FORM, this.INK, this.PAPER}));

    public PrintingPressBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SFMBlockEntities.PRINTING_PRESS_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readItems(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeItems(tag);
    }

    private void writeItems(CompoundTag tag) {
        tag.m_128365_("form", (Tag)this.FORM.serializeNBT());
        tag.m_128365_("paper", (Tag)this.PAPER.serializeNBT());
        tag.m_128365_("ink", (Tag)this.INK.serializeNBT());
    }

    private void readItems(CompoundTag tag) {
        this.INK.deserializeNBT(tag.m_128469_("ink"));
        this.PAPER.deserializeNBT(tag.m_128469_("paper"));
        this.FORM.deserializeNBT(tag.m_128469_("form"));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == SFMWellKnownCapabilities.ITEM_HANDLER.capabilityKind()) {
            return this.ITEMS_CAPABILITY.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack acceptStack(ItemStack stack) {
        if (!stack.m_41619_()) {
            ItemStack remainder = this.FORM.insertItem(0, stack.m_41777_(), false);
            if (remainder.m_41613_() < stack.m_41613_()) {
                stack.m_41774_(stack.m_41613_() - remainder.m_41613_());
                return stack;
            }
            remainder = this.INK.insertItem(0, stack.m_41777_(), false);
            if (remainder.m_41613_() < stack.m_41613_()) {
                stack.m_41774_(stack.m_41613_() - remainder.m_41613_());
                return stack;
            }
            remainder = this.PAPER.insertItem(0, stack.m_41777_(), false);
            if (remainder.m_41613_() < stack.m_41613_()) {
                stack.m_41774_(stack.m_41613_() - remainder.m_41613_());
                return stack;
            }
        } else {
            ItemStack found = this.PAPER.extractItem(0, 64, false);
            if (!found.m_41619_()) {
                return found;
            }
            found = this.FORM.extractItem(0, 64, false);
            if (!found.m_41619_()) {
                return found;
            }
            found = this.INK.extractItem(0, 64, false);
            if (!found.m_41619_()) {
                return found;
            }
        }
        return stack;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeItems(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.readItems(tag);
        }
    }

    public ItemStack getPaper() {
        return this.PAPER.getStackInSlot(0);
    }

    public ItemStack getInk() {
        return this.INK.getStackInSlot(0);
    }

    public ItemStack getForm() {
        return this.FORM.getStackInSlot(0);
    }

    public void performPrint() {
        if (this.m_58904_() == null) {
            return;
        }
        RecipeManager recipeManager = this.m_58904_().m_7465_();
        recipeManager.m_44015_((RecipeType)SFMRecipeTypes.PRINTING_PRESS.get(), (Container)this, this.m_58904_()).ifPresent(recipe -> {
            ItemStack paper = this.getPaper();
            ItemStack ink = this.getInk();
            ItemStack form = this.getForm();
            if (paper.m_41619_() || ink.m_41619_() || form.m_41619_()) {
                return;
            }
            paper = this.assembleRecipe((PrintingPressRecipe)recipe);
            this.PAPER.setStackInSlot(0, paper);
            ink.m_41774_(1);
            this.INK.setStackInSlot(0, ink);
        });
    }

    @MCVersionDependentBehaviour
    private ItemStack assembleRecipe(PrintingPressRecipe recipe) {
        assert (this.f_58857_ != null);
        return recipe.assemble(this, this.f_58857_.m_9598_());
    }

    public ItemStack[] getStacksToDrop() {
        return new ItemStack[]{this.getPaper(), this.getInk(), this.getForm()};
    }
}

