/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_editor;

import ca.teamdman.sfm.client.text_editor.Caret;
import ca.teamdman.sfm.client.text_editor.Cursor;
import ca.teamdman.sfm.client.text_editor.MultiCursor;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunctions;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;

public record TextEditContext(MultiCursor multiCursor, LinkedList<StringBuilder> lines) {
    public TextEditContext() {
        this(new MultiCursor(), new LinkedList<StringBuilder>());
        this.lines.add(new StringBuilder());
    }

    public TextEditContext(String initialContent) {
        this(new MultiCursor(), new LinkedList<StringBuilder>());
        if (initialContent.isEmpty()) {
            this.lines.add(new StringBuilder());
        } else {
            String[] splitLines;
            for (String line : splitLines = initialContent.split("\n")) {
                this.lines.add(new StringBuilder(line));
            }
        }
    }

    public Int2IntFunction lineLengths() {
        return Int2IntFunctions.primitive(x -> {
            if (x < 0 || x >= this.lines.size()) {
                return -1;
            }
            return this.lines.get((int)x).length();
        });
    }

    public TextEditContext copy() {
        return new TextEditContext(new MultiCursor(new ArrayDeque<Cursor>(this.multiCursor().cursors())), this.lines.stream().map(StringBuilder::new).collect(Collectors.toCollection(LinkedList::new)));
    }

    @Override
    public String toString() {
        return "TextEditContext{multiCursor=" + this.multiCursor + ", lines=" + this.lines.size() + ", length=" + this.getCharacterCount() + "}";
    }

    public int getCharacterCount() {
        return this.lines.stream().mapToInt(rec$ -> ((StringBuilder)rec$).length()).sum() + this.lines().size() - 1;
    }

    public void assertInvariants() {
        if (this.multiCursor().cursors().isEmpty()) {
            throw new IllegalStateException("Must have at least one cursor.");
        }
        for (Cursor cursor : this.multiCursor().cursors()) {
            if (cursor == null) {
                throw new IllegalStateException("Cursor cannot be null.");
            }
            if (cursor.head().lineIndex() < 0) {
                throw new IllegalStateException("Cursor head line cannot be negative.");
            }
            if (cursor.tail().lineIndex() < 0) {
                throw new IllegalStateException("Cursor head line cannot be negative.");
            }
            if (this.lines.get(cursor.head().lineIndex()).length() < cursor.head().gapIndex()) {
                throw new IllegalStateException("Cursor head gap index cannot be greater than line length.");
            }
            if (this.lines.get(cursor.tail().lineIndex()).length() >= cursor.tail().gapIndex()) continue;
            throw new IllegalStateException("Cursor tail gap index cannot be greater than line length.");
        }
    }

    public Int2ObjectOpenHashMap<IntervalSet> selectedCharactersByLine() {
        Int2ObjectOpenHashMap rtn = new Int2ObjectOpenHashMap();
        int numLines = this.lines().size();
        for (int lineIndex = 0; lineIndex < numLines; ++lineIndex) {
            IntervalSet selectedCharacterIndicesInLine = new IntervalSet(new int[0]);
            int lineLength = this.lines().get(lineIndex).length();
            for (Cursor cursor : this.multiCursor().cursors()) {
                if (!cursor.hasSelection()) continue;
                Caret beginning = cursor.getBeginning();
                Caret end = cursor.getEnd();
                if (beginning.lineIndex() == lineIndex && end.lineIndex() == lineIndex) {
                    selectedCharacterIndicesInLine.add(beginning.gapIndex(), end.gapIndex() - 1);
                    continue;
                }
                if (beginning.lineIndex() < lineIndex && end.lineIndex() > lineIndex) {
                    selectedCharacterIndicesInLine.add(0, lineLength - 1);
                    continue;
                }
                if (beginning.lineIndex() < lineIndex && end.lineIndex() == lineIndex) {
                    selectedCharacterIndicesInLine.add(0, end.gapIndex() - 1);
                    continue;
                }
                if (beginning.lineIndex() != lineIndex || end.lineIndex() <= lineIndex) continue;
                selectedCharacterIndicesInLine.add(beginning.gapIndex(), lineLength - 1);
            }
            if (selectedCharacterIndicesInLine.isNil()) continue;
            rtn.put(lineIndex, (Object)selectedCharacterIndicesInLine);
        }
        return rtn;
    }

    public void deleteSelectedText() {
        Int2ObjectOpenHashMap<IntervalSet> selectedCharactersByLine = this.selectedCharactersByLine();
        ListIterator<StringBuilder> lineIterator = this.lines().listIterator(this.lines().size());
        while (lineIterator.hasPrevious()) {
            int lineIndex = lineIterator.previousIndex();
            StringBuilder line = lineIterator.previous();
            IntervalSet selectedCharacterIndicesInLine = (IntervalSet)selectedCharactersByLine.get(lineIndex);
            if (selectedCharacterIndicesInLine == null) continue;
            List intervals = selectedCharacterIndicesInLine.getIntervals();
            ListIterator intervalIterator = intervals.listIterator(intervals.size());
            while (intervalIterator.hasPrevious()) {
                Interval interval = (Interval)intervalIterator.previous();
                line.delete(interval.a, interval.b);
            }
        }
        IntervalSet linesToJoinIntoPrevious = new IntervalSet(new int[0]);
        for (Cursor cursor : this.multiCursor().cursors()) {
            if (!cursor.hasSelection()) continue;
            Caret beginning = cursor.getBeginning();
            Caret end = cursor.getEnd();
            if (beginning.lineIndex() >= end.lineIndex()) continue;
            linesToJoinIntoPrevious.add(beginning.lineIndex() + 1, end.lineIndex());
        }
        if (linesToJoinIntoPrevious.contains(0)) {
            throw new IllegalStateException("Cannot join the first line into a previous line.");
        }
        lineIterator = this.lines().listIterator();
        lineIterator.next();
        int lineIndex = 0;
        while (lineIterator.hasNext()) {
            StringBuilder line = lineIterator.next();
            if (linesToJoinIntoPrevious.contains(lineIndex)) {
                lineIterator.remove();
                StringBuilder previousLine = lineIterator.previous();
                previousLine.append((CharSequence)line);
            }
            ++lineIndex;
        }
        IntervalSet modifiedCursorIndices = new IntervalSet(new int[0]);
        Iterator<Cursor> iterator = this.multiCursor().cursors().iterator();
        int cursorIndex = 0;
        while (iterator.hasNext()) {
            Cursor cursor = iterator.next();
            if (cursor.hasSelection()) {
                Caret newHead = cursor.getBeginning();
                Caret newTail = cursor.getBeginning();
                iterator.remove();
                this.multiCursor().cursors().add(new Cursor(newHead, newTail));
                modifiedCursorIndices.add(cursorIndex, cursorIndex);
            }
            ++cursorIndex;
        }
        for (Cursor cursor : this.multiCursor().cursors()) {
            if (!cursor.hasSelection()) continue;
            throw new IllegalStateException("There should be no selections after removing selections.");
        }
        this.assertInvariants();
    }

    public void insertTextAtCursors(String text) {
        this.deleteSelectedText();
        Int2ObjectOpenHashMap caretsByLine = new Int2ObjectOpenHashMap();
        for (Cursor cursor : this.multiCursor().cursors()) {
            if (cursor.hasSelection()) {
                throw new IllegalStateException("Cannot insert text at cursors with selections.");
            }
            ((IntList)caretsByLine.computeIfAbsent(cursor.head().lineIndex(), k -> new IntArrayList())).add(cursor.head().gapIndex());
        }
        caretsByLine.values().forEach(caretPositions -> caretPositions.sort(IntComparators.NATURAL_COMPARATOR));
        new StringBuilder().trimToSize();
        caretsByLine.forEach((lineIndex, carets) -> {
            StringBuilder line = this.lines().get((int)lineIndex);
            int oldLength = line.length();
            line.setLength(line.length() + carets.size() * text.length());
            line.setLength(oldLength);
            IntListIterator gapIterator = carets.listIterator(carets.size());
            while (gapIterator.hasPrevious()) {
                int gapIndex = gapIterator.previousInt();
                line.insert(gapIndex, text);
            }
        });
        this.assertInvariants();
    }

    public String getContent() {
        StringBuilder rtn = new StringBuilder();
        for (StringBuilder line : this.lines()) {
            rtn.append((CharSequence)line);
            if (line == this.lines().getLast()) continue;
            rtn.append('\n');
        }
        return rtn.toString();
    }
}

