/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.mimir;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.base.BlockEntityMana;
import mythicbotany.register.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.capability.ItemCapabilities;
import org.moddingx.libx.inventory.BaseItemStackHandler;

public class TileYggdrasilBranch
extends BlockEntityMana
implements TickingBlock {
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)1).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
    }).validator(stack -> stack.m_41720_() == ModItems.gjallarHornEmpty, new int[]{0}).build();
    private final LazyOptional<IItemHandlerModifiable> itemCap = ItemCapabilities.create(() -> this.inventory).cast();
    private int progress = 0;

    public TileYggdrasilBranch(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 10000, true, false);
    }

    @Override
    protected boolean canReceive() {
        return true;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemCap : super.getCapability(cap, side);
    }

    public void tick() {
        if (this.inventory.getStackInSlot(0).m_41720_() == ModItems.gjallarHornEmpty && this.inventory.getStackInSlot(0).m_41613_() == 1) {
            if (this.mana >= 20) {
                if (!this.f_58857_.f_46443_) {
                    this.mana -= 10;
                    ++this.progress;
                    if (this.progress >= 600) {
                        this.inventory.setStackInSlot(0, new ItemStack((ItemLike)ModItems.gjallarHornFull));
                        this.progress = 0;
                    }
                    this.m_6596_();
                    this.setDispatchable();
                } else if (this.f_58857_.m_46467_() % 4L == 0L) {
                    double xf = 0.5;
                    double zf = 0.35;
                    Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
                    if (dir.m_122434_() == Direction.Axis.X) {
                        double tmp = xf;
                        xf = zf;
                        zf = tmp;
                    }
                    if (dir.m_122421_() == Direction.AxisDirection.POSITIVE) {
                        xf = 1.0 - xf;
                        zf = 1.0 - zf;
                    }
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123803_, (double)this.f_58858_.m_123341_() + xf, (double)this.f_58858_.m_123342_() + 0.76, (double)this.f_58858_.m_123343_() + zf, 0.0, -0.2, 0.0);
                }
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.m_6596_();
            this.setDispatchable();
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.progress = nbt.m_128451_("Progress");
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("Progress", this.progress);
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (!this.f_58857_.f_46443_) {
            nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_.f_46443_) {
            this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        }
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }
}

