/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.MythicBotany;
import mythicbotany.MythicCap;
import mythicbotany.config.MythicConfig;
import mythicbotany.pylon.PylonRepairable;
import mythicbotany.register.ModItems;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.moddingx.libx.creativetab.CreativeTabItemProvider;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.SetupContext;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfsteelPick
extends TerraShattererItem
implements PylonRepairable,
Registerable,
CreativeTabItemProvider {
    public AlfsteelPick(Item.Properties props) {
        super(props.m_41503_(MythicConfig.alftools.durability.pickaxe.max_durability()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(SetupContext ctx) {
        ctx.enqueue(() -> {
            ItemProperties.register((Item)ModItems.alfsteelPick, (ResourceLocation)MythicBotany.getInstance().resource("tipped"), (stack, level, entity, seed) -> AlfsteelPick.isTipped((ItemStack)stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)ModItems.alfsteelPick, (ResourceLocation)MythicBotany.getInstance().resource("active"), (stack, level, entity, seed) -> AlfsteelPick.isEnabled((ItemStack)stack) ? 1.0f : 0.0f);
        });
    }

    public int getManaPerDamage() {
        return MythicConfig.alftools.durability.pickaxe.mana_per_durability();
    }

    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (AlfsteelPick.isEnabled((ItemStack)stack)) {
            Level level = player.m_9236_();
            BlockState state = level.m_8055_(pos);
            Predicate<BlockState> blockTest = stateToMine -> {
                if (stateToMine.m_60834_() && !stack.m_41735_(stateToMine)) {
                    return false;
                }
                if (stack.m_41691_(stateToMine) <= 0.0f) {
                    return false;
                }
                return stack.m_41691_(stateToMine) > 1.0f || stateToMine.m_204336_(BlockTags.f_144282_) || stateToMine.m_204336_(BlockTags.f_144283_) || stateToMine.m_204336_(BlockTags.f_144281_);
            };
            if (!level.m_46859_(pos) && blockTest.test(state) && !level.m_46859_(pos)) {
                boolean thor = !RingOfThorItem.getThorRing((Player)player).m_41619_();
                boolean doX = thor || side.m_122429_() == 0;
                boolean doY = thor || side.m_122430_() == 0;
                boolean doZ = thor || side.m_122431_() == 0;
                int origLevel = AlfsteelPick.getLevel((ItemStack)stack);
                int miningLevel = origLevel + (thor ? 1 : 0);
                int rangeDepth = miningLevel / 2;
                if (StoneOfTemperanceItem.hasTemperanceActive((Player)player) && miningLevel > 2) {
                    miningLevel = 2;
                    rangeDepth = 0;
                }
                int range = miningLevel - 1;
                int rangeY = Math.max(1, range);
                if (range != 0 || miningLevel == 1) {
                    Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
                    Vec3i endDiff = new Vec3i(doX ? range : rangeDepth * -side.m_122429_(), doY ? rangeY * 2 - 1 : 0, doZ ? range : rangeDepth * -side.m_122431_());
                    ToolCommons.removeBlocksInIteration((Player)player, (ItemStack)stack, (Level)level, (BlockPos)pos, (Vec3i)beginDiff, (Vec3i)endDiff, blockTest);
                    if (origLevel == 5) {
                        PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix((String)"challenge/rank_ss_pick"), (String)"code_triggered");
                    }
                }
            }
        }
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.m_41720_() == ModItems.alfsteelIngot || !Ingredient.m_204132_((TagKey)BotaniaTags.Items.INGOTS_TERRASTEEL).test(repair) && super.m_6832_(toRepair, repair);
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return (int)(2.5 * (double)this.getManaPerDamage());
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.m_41721_(Math.max(0, stack.m_41773_() - 5));
        return stack;
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new MythicCap<ManaItem>(super.initCapabilities(stack, nbt), BotaniaForgeCapabilities.MANA_ITEM, () -> new TerraShattererItem.ManaItemImpl(stack));
    }

    public Stream<ItemStack> makeCreativeTabStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(8);
        stacks.add(new ItemStack((ItemLike)this));
        for (int mana : new int[]{999999, 9999999, 99999999, 999999999, 0x7FFFFFFE}) {
            ItemStack stack = new ItemStack((ItemLike)this);
            AlfsteelPick.setMana((ItemStack)stack, (int)mana);
            stacks.add(stack);
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        AlfsteelPick.setMana((ItemStack)stack, (int)999999);
        AlfsteelPick.setTipped((ItemStack)stack);
        stacks.add(stack);
        return stacks.stream();
    }
}

