/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content;

import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.item.CrystalixWand;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class CrystalixRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"crystalix");
    public static final TagKey<Item> ITEM_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("crystalix", "blocks"));
    public static final TagKey<Block> BLOCK_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("crystalix", "blocks"));
    public static final Map<BlockTypes, TagKey<Block>> BLOCK_TAGS = Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> BlockTags.create((ResourceLocation)new ResourceLocation("crystalix", type.m_7912_())), (a, b) -> b, () -> new EnumMap(BlockTypes.class)));
    public static final Map<BlockTypes, TagKey<Item>> ITEM_TAGS = Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> ItemTags.create((ResourceLocation)new ResourceLocation("crystalix", type.m_7912_())), (a, b) -> b, () -> new EnumMap(BlockTypes.class)));
    public static final String SHADELESS = "shadeless";
    public static final String REINFORCED = "reinforced";
    public static final String LIGHT = "light";
    public static final String GHOST = "ghost";
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"crystalix");
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"crystalix");
    public static final RegistryObject<CrystalixWand> WAND = ITEMS.register("crystalix_wand", () -> new CrystalixWand(new Item.Properties()));
    public static final Map<DyeColor, Map<BlockTypes, RegistryObject<CrystalixGlass>>> BLOCKS_MAP = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> Arrays.stream(BlockTypes.values()).collect(Collectors.toMap(Function.identity(), type -> {
        String name = type == BlockTypes.GLASS ? String.format("%s_crystalix_glass", color.m_41065_()) : String.format("%s_%s_crystalix_glass", color.m_41065_(), type.m_7912_());
        return CrystalixRegistry.register(name, () -> new CrystalixGlass((DyeColor)color));
    }, (a, b) -> b, () -> new EnumMap(BlockTypes.class))), (a, b) -> b, () -> new EnumMap(DyeColor.class)));
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)String.format("itemGroup.%s", "crystalix"))).m_257737_(() -> ((CrystalixGlass)((Object)((Object)((Object)BLOCKS_MAP.get(DyeColor.WHITE).get((Object)BlockTypes.GLASS).get())))).m_5456_().m_7968_()).m_257501_((parameters, output) -> ITEMS.getEntries().stream().map(Supplier::get).map(Item::m_7968_).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).m_257652_());

    private static RegistryObject<CrystalixGlass> register(String name, Supplier<CrystalixGlass> properties) {
        RegistryObject block = BLOCKS.register(name, properties);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static enum BlockTypes implements StringRepresentable
    {
        GLASS((TagKey<Item>)Tags.Items.GEMS_AMETHYST),
        CLEAR((TagKey<Item>)Tags.Items.GEMS_QUARTZ),
        BORDERED((TagKey<Item>)Tags.Items.INGOTS_IRON);

        private final TagKey<Item> tag;

        private BlockTypes(TagKey<Item> tag) {
            this.tag = tag;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

