/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets;

import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="charginggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        generator.addProvider(includeClient, (DataProvider)new GeneratorLanguage(packOutput));
        generator.addProvider(includeClient, (DataProvider)new GeneratorBlockStates(packOutput, event.getExistingFileHelper()));
        generator.addProvider(includeClient, (DataProvider)new GeneratorLoots(packOutput));
        generator.addProvider(includeServer, (DataProvider)new GeneratorRecipes(packOutput));
        generator.addProvider(includeServer, (DataProvider)new GeneratorBlockTags(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(includeServer, (DataProvider)new GeneratorItemModels(packOutput, event.getExistingFileHelper()));
    }

    static class GeneratorLanguage
    extends LanguageProvider {
        public GeneratorLanguage(PackOutput output) {
            super(output, "charginggadgets", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)BlockRegistry.CHARGING_STATION, "Charging Station");
            this.add("itemGroup.charginggadgets", "Charging Gadgets");
            this.add("screen.charginggadgets.energy", "Energy: %s/%s FE");
            this.add("screen.charginggadgets.no_fuel", "Fuel source empty");
            this.add("screen.charginggadgets.burn_time", "Burn time left: %ss");
        }
    }

    static class GeneratorBlockStates
    extends BlockStateProvider {
        public GeneratorBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "charginggadgets", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.horizontalBlock((Block)BlockRegistry.CHARGING_STATION.get(), (ModelFile)this.models().orientableWithBottom(BlockRegistry.CHARGING_STATION.getId().m_135815_(), this.modLoc("block/charging_station_side"), this.modLoc("block/charging_station_fronton"), this.modLoc("block/charging_station_bottom"), this.modLoc("block/charging_station_top")));
        }
    }

    static class GeneratorLoots
    extends LootTableProvider {
        public GeneratorLoots(PackOutput output) {
            super(output, Set.of(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.f_81421_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> table.m_79136_(validationContext.m_79355_(table.m_79122_()).m_278632_("{" + name + "}", new LootDataId(LootDataType.f_278413_, name))));
        }

        private static class Blocks
        extends BlockLootSubProvider {
            protected Blocks() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            protected void m_245660_() {
                LootPool.Builder builder = LootPool.m_79043_().name(BlockRegistry.CHARGING_STATION.getId().toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BlockRegistry.CHARGING_STATION.get())).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
                this.m_247577_((Block)BlockRegistry.CHARGING_STATION.get(), LootTable.m_79147_().m_79161_(builder));
            }

            protected Iterable<Block> getKnownBlocks() {
                return Collections.singletonList((Block)BlockRegistry.CHARGING_STATION.get());
            }
        }
    }

    static class GeneratorRecipes
    extends RecipeProvider {
        public GeneratorRecipes(PackOutput output) {
            super(output);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            Block block = (Block)BlockRegistry.CHARGING_STATION.get();
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)block).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('l'), Tags.Items.STORAGE_BLOCKS_COAL).m_206416_(Character.valueOf('d'), Tags.Items.GEMS_LAPIS).m_126130_("iri").m_126130_("drd").m_126130_("ili").m_126132_("has_diamonds", (CriterionTriggerInstance)GeneratorRecipes.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(consumer);
        }
    }

    static class GeneratorBlockTags
    extends BlockTagsProvider {
        public GeneratorBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "charginggadgets", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider lookup) {
            this.m_206424_(BlockTags.f_144282_).m_255245_((Object)((Block)BlockRegistry.CHARGING_STATION.get()));
        }
    }

    static class GeneratorItemModels
    extends ItemModelProvider {
        public GeneratorItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "charginggadgets", existingFileHelper);
        }

        protected void registerModels() {
            String path = BlockRegistry.CHARGING_STATION.getId().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

