/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import org.jetbrains.annotations.Nullable;

public record RequestControllerTargetHighlightsMessage(ItemStack stack, List<BlockPos> controllerPositions) {
    public static void encode(RequestControllerTargetHighlightsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeItemStack(msg.stack(), false);
        packetBuffer.m_236828_(msg.controllerPositions(), FriendlyByteBuf::m_130064_);
    }

    public static RequestControllerTargetHighlightsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RequestControllerTargetHighlightsMessage(packetBuffer.m_130267_(), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_));
    }

    static void onMessage(RequestControllerTargetHighlightsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestControllerTargetHighlightsMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    public static void handleMessage(RequestControllerTargetHighlightsMessage payload, @Nullable ServerPlayer player) {
        ArrayList stackStorages = new ArrayList();
        ArrayList itemStorages = new ArrayList();
        ArrayList emptyTargetSlotStorages = new ArrayList();
        ItemStackKey stackKey = ItemStackKey.of((ItemStack)payload.stack());
        payload.controllerPositions().forEach(pos -> {
            Level level = player.m_9236_();
            WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(controller -> {
                stackStorages.addAll(controller.getStackStorages(stackKey));
                itemStorages.addAll(controller.getItemStorages(stackKey));
                emptyTargetSlotStorages.addAll(controller.getEmptyTargetSlotStorages(stackKey));
            });
        });
        PacketHandler.INSTANCE.sendToClient(player, (Object)new SyncItemHighlightsMessage(stackStorages, itemStorages, emptyTargetSlotStorages));
    }
}

