/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class GenericWoodStorageRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapedRecipe compose;

    public GenericWoodStorageRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.m_7527_(), compose.f_44149_);
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return super.m_5818_(inv, level) && this.hasMixedOrNonCustomWood(inv);
    }

    private TopLeftCornerCoords getTopLeftCornerCoords(CraftingContainer inv) {
        if (this.m_44221_() * this.m_44220_() == inv.m_6643_()) {
            return new TopLeftCornerCoords(0, 0);
        }
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        for (int row = 0; row < inv.m_39346_() - this.m_44221_(); ++row) {
            for (int col = 0; col < inv.m_39347_() - this.m_44220_(); ++col) {
                if (inv.m_8020_(col + row * inv.m_39347_()).m_41619_()) continue;
                minRow = Math.min(minRow, row);
                minCol = Math.min(minCol, col);
            }
        }
        return new TopLeftCornerCoords(minCol, minRow);
    }

    private boolean hasMixedOrNonCustomWood(CraftingContainer inv) {
        TopLeftCornerCoords topLeftCorner = this.getTopLeftCornerCoords(inv);
        LinkedHashSet<BlockFamily> customFamilies = new LinkedHashSet<BlockFamily>();
        for (int row = topLeftCorner.top; row < topLeftCorner.top + this.m_44221_(); ++row) {
            for (int col = topLeftCorner.left; col < topLeftCorner.left + this.m_44220_(); ++col) {
                int slot = col + row * inv.m_39347_();
                ItemStack itemStack = inv.m_8020_(slot);
                if (itemStack.m_41619_() || ((Ingredient)this.m_7527_().get(slot)).m_43908_().length < 2) continue;
                Optional<BlockFamily> customBlockFamily = this.getCustomBlockFamily(itemStack.m_41720_());
                if (customBlockFamily.isEmpty()) {
                    return true;
                }
                customFamilies.add(customBlockFamily.get());
            }
        }
        return customFamilies.size() > 1;
    }

    private Optional<BlockFamily> getCustomBlockFamily(Item item) {
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem blockItem = (BlockItem)item;
        for (BlockFamily family : WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.values()) {
            if (blockItem.m_40614_() != family.m_175951_() && blockItem.m_40614_() != family.m_175952_(BlockFamily.Variant.SLAB)) continue;
            return Optional.of(family);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.GENERIC_WOOD_STORAGE_RECIPE_SERIALIZER.get();
    }

    private record TopLeftCornerCoords(int left, int top) {
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, GenericWoodStorageRecipe> {
        public Serializer() {
            super(GenericWoodStorageRecipe::new, RecipeSerializer.f_44076_);
        }
    }
}

