/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.DisabledPeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PeripheralBlockEntity<T extends BasePeripheral<?>>
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IPeripheralTileEntity {
    private static final String PERIPHERAL_SETTINGS_KEY = "peripheralSettings";
    protected CompoundTag peripheralSettings = new CompoundTag();
    protected NonNullList<ItemStack> items;
    private LazyOptional<? extends IItemHandler> handler = LazyOptional.empty();
    private LazyOptional<? extends IFluidHandler> fluidHandler = LazyOptional.empty();
    private LazyOptional<IPeripheral> peripheralCap = LazyOptional.empty();

    protected PeripheralBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            this.items = NonNullList.m_122780_((int)inventoryBlock.getInvSize(), (Object)ItemStack.f_41583_);
        } else {
            this.items = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
        }
    }

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getLazyPeripheral().cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (!this.f_58859_ && direction != null && this instanceof IInventoryBlock) {
                if (!this.handler.isPresent()) {
                    this.handler = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.NORTH));
                }
                return this.handler.cast();
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER && !this.f_58859_ && direction != null) {
            if (!this.fluidHandler.isPresent()) {
                this.fluidHandler = LazyOptional.of(() -> new FluidTank(0));
            }
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.peripheralCap.invalidate();
        this.handler.invalidate();
        this.fluidHandler.invalidate();
    }

    @NotNull
    protected abstract T createPeripheral();

    protected IPeripheral createPeripheralDisable() {
        T peripheral = this.createPeripheral();
        if (peripheral.isEnabled()) {
            return peripheral;
        }
        return new DisabledPeripheral((IPeripheral)peripheral);
    }

    public Iterable<IComputerAccess> getConnectedComputers() {
        return this.getPeripheralOptional().map(BasePeripheral::getConnectedComputers).orElse(Collections.emptyList());
    }

    public LazyOptional<IPeripheral> getLazyPeripheral() {
        if (!this.peripheralCap.isPresent()) {
            this.peripheralCap = LazyOptional.of(this::createPeripheralDisable);
        }
        return this.peripheralCap;
    }

    @Nullable
    public T getPeripheral() {
        IPeripheral peripheral = (IPeripheral)this.getLazyPeripheral().orElse(null);
        if (peripheral == null || peripheral instanceof DisabledPeripheral) {
            return null;
        }
        return (T)((BasePeripheral)peripheral);
    }

    public Optional<T> getPeripheralOptional() {
        return Optional.ofNullable(this.getPeripheral());
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        this.peripheralSettings = compound.m_128469_(PERIPHERAL_SETTINGS_KEY);
        super.m_142466_(compound);
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveShared(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        if (!this.peripheralSettings.m_128456_()) {
            compound.m_128365_(PERIPHERAL_SETTINGS_KEY, (Tag)this.peripheralSettings);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        this.saveShared(compound);
        return compound;
    }

    protected void saveShared(@NotNull CompoundTag compound) {
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    protected Component m_6820_() {
        Component component;
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            component = inventoryBlock.m_5446_();
        } else {
            component = null;
        }
        return component;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player playerEntity) {
        return this.m_6555_(id, inventory);
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        AbstractContainerMenu abstractContainerMenu;
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            abstractContainerMenu = (AbstractContainerMenu)inventoryBlock.createContainer(id, player, this.f_58858_, this.f_58857_);
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{0};
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack removed = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!removed.m_41619_()) {
            this.m_6596_();
        }
        return removed;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    @Override
    public CompoundTag getPeripheralSettings() {
        return this.peripheralSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.m_6596_();
    }

    public void markDataSync() {
        Level level = this.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        this.m_6596_();
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
    }
}

