/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanToolData {
    public static final int NUM_SLOTS = 10;
    private static final String NBT_SLOTS = "structurize:slots";
    private static final String NBT_CURRENT = "structurize:cur";
    private final CompoundTag tag;

    public ScanToolData(@NotNull CompoundTag tag) {
        this.tag = tag;
    }

    @NotNull
    public CompoundTag getInternalTag() {
        return this.tag;
    }

    public int getCurrentSlotId() {
        return this.tag.m_128441_(NBT_CURRENT) ? Math.max(0, Math.min(9, this.tag.m_128451_(NBT_CURRENT))) : 1;
    }

    @NotNull
    public Slot getCurrentSlotData() {
        ListTag slots;
        int current = this.getCurrentSlotId();
        return new Slot(Objects.requireNonNullElse(current < (slots = this.tag.m_128437_(NBT_SLOTS, 10)).size() ? slots.m_128728_(current) : null, new CompoundTag()));
    }

    public void setCurrentSlotData(@Nullable Slot data) {
        int current = this.getCurrentSlotId();
        ListTag slots = this.tag.m_128437_(NBT_SLOTS, 10);
        while (current >= slots.size()) {
            slots.add((Object)new CompoundTag());
        }
        slots.set(current, (Tag)(data == null ? new CompoundTag() : data.write(new CompoundTag())));
        this.tag.m_128365_(NBT_SLOTS, (Tag)slots);
    }

    public void nextSlot() {
        this.moveTo((this.getCurrentSlotId() + 1) % 10);
    }

    public void prevSlot() {
        this.moveTo((this.getCurrentSlotId() + 10 - 1) % 10);
    }

    public void moveTo(int slot) {
        this.tag.m_128405_(NBT_CURRENT, slot);
    }

    public static class Slot {
        private final String name;
        private final BoxPreviewData box;

        public Slot(@NotNull String name, @NotNull BoxPreviewData box) {
            this.name = name;
            this.box = box;
        }

        public Slot(@NotNull CompoundTag tag) {
            BlockPos corner1 = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("c1"));
            BlockPos corner2 = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("c2"));
            Optional<BlockPos> anchor = tag.m_128441_("a") ? Optional.of(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("a"))) : Optional.empty();
            this.box = new BoxPreviewData(corner1, corner2, anchor);
            this.name = tag.m_128461_("n");
        }

        public CompoundTag write(@NotNull CompoundTag tag) {
            tag.m_128365_("c1", (Tag)NbtUtils.m_129224_((BlockPos)this.box.getPos1()));
            tag.m_128365_("c2", (Tag)NbtUtils.m_129224_((BlockPos)this.box.getPos2()));
            if (this.box.getAnchor().isPresent()) {
                tag.m_128365_("a", (Tag)NbtUtils.m_129224_((BlockPos)this.box.getAnchor().get()));
            } else {
                tag.m_128473_("a");
            }
            tag.m_128359_("n", this.name);
            return tag;
        }

        public boolean isEmpty() {
            return this.name.isEmpty();
        }

        @NotNull
        public BoxPreviewData getBox() {
            return this.box;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

