/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.PlacerholderFillOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class FillTopPlaceholderMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private double yStretch;
    private double circleRadiusMult;
    private int heightOffset;
    private int minDistToBlocks;

    public FillTopPlaceholderMessage(FriendlyByteBuf buf) {
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.yStretch = buf.readDouble();
        this.circleRadiusMult = buf.readDouble();
        this.heightOffset = buf.readInt();
        this.minDistToBlocks = buf.readInt();
    }

    public FillTopPlaceholderMessage(BlockPos pos1, BlockPos pos2, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        this.from = pos1;
        this.to = pos2;
        this.yStretch = yStretch;
        this.circleRadiusMult = circleRadiusMult;
        this.heightOffset = heightOffset;
        this.minDistToBlocks = minDistToBlocks;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.writeDouble(this.yStretch);
        buf.writeDouble(this.circleRadiusMult);
        buf.writeInt(this.heightOffset);
        buf.writeInt(this.minDistToBlocks);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        Manager.addToQueue(new PlacerholderFillOperation(this.from, this.to, (Player)ctxIn.getSender(), this.yStretch, this.circleRadiusMult, this.heightOffset, this.minDistToBlocks));
    }
}

