/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.AbsorbBlockMessage;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.ClientBlueprintRequestMessage;
import com.ldtteam.structurize.network.messages.FillTopPlaceholderMessage;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.ItemMiddleMouseMessage;
import com.ldtteam.structurize.network.messages.NotifyClientAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.NotifyServerAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.OperationHistoryMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.ScanToolTeleportMessage;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.SetTagInTool;
import com.ldtteam.structurize.network.messages.ShowScanMessage;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToClient;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.network.messages.TransferStructurePackToClient;
import com.ldtteam.structurize.network.messages.UndoRedoMessage;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.network.messages.splitting.SplitPacketMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkChannel {
    private final SimpleChannel rawChannel;
    private final Map<Integer, NetworkingMessageEntry<?>> messagesTypes = Maps.newHashMap();
    private final Map<Class<? extends IMessage>, Integer> messageTypeToIdMap = Maps.newHashMap();
    private final Cache<Integer, Map<Integer, byte[]>> messageCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(8).build();
    private final AtomicInteger messageCounter = new AtomicInteger();

    public NetworkChannel(String channelName) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById("structurize").get()).getModInfo().getVersion().toString();
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("structurize", channelName), () -> modVersion, str -> str.equals(modVersion), str -> str.equals(modVersion));
    }

    public void registerCommonMessages() {
        this.setupInternalMessages();
        int idx = 0;
        this.registerMessage(++idx, RemoveBlockMessage.class, RemoveBlockMessage::new);
        this.registerMessage(++idx, RemoveEntityMessage.class, RemoveEntityMessage::new);
        this.registerMessage(++idx, SaveScanMessage.class, SaveScanMessage::new);
        this.registerMessage(++idx, ReplaceBlockMessage.class, ReplaceBlockMessage::new);
        this.registerMessage(++idx, FillTopPlaceholderMessage.class, FillTopPlaceholderMessage::new);
        this.registerMessage(++idx, ScanOnServerMessage.class, ScanOnServerMessage::new);
        this.registerMessage(++idx, ServerUUIDMessage.class, ServerUUIDMessage::new);
        this.registerMessage(++idx, UndoRedoMessage.class, UndoRedoMessage::new);
        this.registerMessage(++idx, UpdateScanToolMessage.class, UpdateScanToolMessage::new);
        this.registerMessage(++idx, UpdateClientRender.class, UpdateClientRender::new);
        this.registerMessage(++idx, BuildToolPlacementMessage.class, BuildToolPlacementMessage::new);
        this.registerMessage(++idx, ShowScanMessage.class, ShowScanMessage::new);
        this.registerMessage(++idx, AddRemoveTagMessage.class, AddRemoveTagMessage::new);
        this.registerMessage(++idx, SetTagInTool.class, SetTagInTool::new);
        this.registerMessage(++idx, OperationHistoryMessage.class, OperationHistoryMessage::new);
        this.registerMessage(++idx, NotifyServerAboutStructurePacksMessage.class, NotifyServerAboutStructurePacksMessage::new);
        this.registerMessage(++idx, BuildToolPlacementMessage.class, BuildToolPlacementMessage::new);
        this.registerMessage(++idx, BlueprintSyncMessage.class, BlueprintSyncMessage::new);
        this.registerMessage(++idx, SyncSettingsToServer.class, SyncSettingsToServer::new);
        this.registerMessage(++idx, SyncPreviewCacheToServer.class, SyncPreviewCacheToServer::new);
        this.registerMessage(++idx, NotifyClientAboutStructurePacksMessage.class, NotifyClientAboutStructurePacksMessage::new);
        this.registerMessage(++idx, TransferStructurePackToClient.class, TransferStructurePackToClient::new);
        this.registerMessage(++idx, ClientBlueprintRequestMessage.class, ClientBlueprintRequestMessage::new);
        this.registerMessage(++idx, SyncPreviewCacheToClient.class, SyncPreviewCacheToClient::new);
        this.registerMessage(++idx, ItemMiddleMouseMessage.class, ItemMiddleMouseMessage::new);
        this.registerMessage(++idx, ScanToolTeleportMessage.class, ScanToolTeleportMessage::new);
        this.registerMessage(++idx, AbsorbBlockMessage.class, AbsorbBlockMessage::new);
    }

    private void setupInternalMessages() {
        this.rawChannel.registerMessage(0, SplitPacketMessage.class, IMessage::toBytes, SplitPacketMessage::new, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT));
        });
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Function<FriendlyByteBuf, MSG> msgCreator) {
        this.messagesTypes.put(id, new NetworkingMessageEntry<MSG>(msgCreator, msgClazz));
        this.messageTypeToIdMap.put(msgClazz, id);
    }

    public void sendToServer(IMessage msg) {
        this.handleSplitting(msg, arg_0 -> ((SimpleChannel)this.rawChannel).sendToServer(arg_0));
    }

    public void sendToPlayer(IMessage msg, ServerPlayer player) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), s));
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToDimension(IMessage msg, ResourceKey<Level> dim) {
        this.rawChannel.send(PacketDistributor.DIMENSION.with(() -> dim), (Object)msg);
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), s));
    }

    public void sendToEveryone(IMessage msg) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.ALL.noArg(), s));
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), s));
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), s));
    }

    public void sendToTrackingChunk(IMessage msg, LevelChunk chunk) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), s));
    }

    private void handleSplitting(IMessage msg, Consumer<IMessage> splitMessageConsumer) {
        int extra;
        int messageId = this.messageTypeToIdMap.getOrDefault(msg.getClass(), -1);
        if (messageId == -1) {
            throw new IllegalArgumentException("The message is unknown to this channel!");
        }
        ByteBuf buffer = Unpooled.buffer();
        FriendlyByteBuf innerFriendlyByteBuf = new FriendlyByteBuf(buffer);
        msg.toBytes(innerFriendlyByteBuf);
        byte[] data = buffer.array();
        buffer.release();
        int max_packet_size = msg.getExecutionSide() == LogicalSide.SERVER ? 30000 : 943718;
        int packetIndex = 0;
        int comId = this.messageCounter.getAndIncrement();
        for (int currentIndex = 0; currentIndex < data.length; currentIndex += extra) {
            this.getMessagesTypes().get(messageId).onSplitting(packetIndex);
            extra = Math.min(max_packet_size, data.length - currentIndex);
            byte[] subPacketData = Arrays.copyOfRange(data, currentIndex, currentIndex + extra);
            SplitPacketMessage splitPacketMessage = new SplitPacketMessage(comId, packetIndex++, currentIndex + extra >= data.length, messageId, subPacketData);
            splitMessageConsumer.accept(splitPacketMessage);
        }
    }

    public Cache<Integer, Map<Integer, byte[]>> getMessageCache() {
        return this.messageCache;
    }

    public Map<Integer, NetworkingMessageEntry<?>> getMessagesTypes() {
        return this.messagesTypes;
    }

    public static final class NetworkingMessageEntry<MSG extends IMessage> {
        private final AtomicBoolean hasWarned = new AtomicBoolean(true);
        private final Function<FriendlyByteBuf, MSG> creator;
        private final Class<? extends IMessage> clazz;

        private NetworkingMessageEntry(Function<FriendlyByteBuf, MSG> creator, Class<? extends IMessage> clazz) {
            this.creator = creator;
            this.clazz = clazz;
        }

        public Function<FriendlyByteBuf, MSG> getCreator() {
            return this.creator;
        }

        public void onSplitting(int packetIndex) {
            if (packetIndex != 1) {
                return;
            }
            if (this.hasWarned.getAndSet(false)) {
                Log.getLogger().warn("Splitting message: " + String.valueOf(this.clazz) + " it is too big to send normally. This message is only printed once");
            }
        }
    }
}

