/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.commands.EntryPoint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.IOPool;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventSubscriber {
    private EventSubscriber() {
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.START) {
                BlockUtils.checkOrInit();
                Manager.onWorldTick(serverLevel);
            }
        } else if (event.level instanceof ClientLevel) {
            BlockUtils.checkOrInit();
        }
    }

    @SubscribeEvent
    public static void onServerStopped(@NotNull ServerStoppingEvent event) {
        IOPool.shutdown();
    }
}

