/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.structurize.config.AbstractConfiguration;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.config.ServerConfiguration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    private final ModConfig client;
    private final ClientConfiguration clientConfig;
    private final ModConfig server;
    private final ServerConfiguration serverConfig;
    private final ModConfig[] activeModConfigs;
    private final AbstractConfiguration[] activeConfigs;
    private final Map<ForgeConfigSpec.ConfigValue<?>, Optional<ForgeConfigSpec.ValueSpec>> valueSpecCache = new IdentityHashMap();

    public Configuration(ModContainer modContainer) {
        Pair ser = new ForgeConfigSpec.Builder().configure(ServerConfiguration::new);
        this.server = new ModConfig(ModConfig.Type.SERVER, (IConfigSpec)ser.getRight(), modContainer);
        this.serverConfig = (ServerConfiguration)ser.getLeft();
        modContainer.addConfig(this.server);
        if (FMLEnvironment.dist.isClient()) {
            Pair cli = new ForgeConfigSpec.Builder().configure(ClientConfiguration::new);
            this.client = new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)cli.getRight(), modContainer);
            this.clientConfig = (ClientConfiguration)cli.getLeft();
            modContainer.addConfig(this.client);
            this.activeModConfigs = new ModConfig[]{this.client, this.server};
            this.activeConfigs = new AbstractConfiguration[]{this.clientConfig, this.serverConfig};
        } else {
            this.client = null;
            this.clientConfig = null;
            this.activeModConfigs = new ModConfig[]{this.server};
            this.activeConfigs = new AbstractConfiguration[]{this.serverConfig};
        }
    }

    public ClientConfiguration getClient() {
        return this.clientConfig;
    }

    public ServerConfiguration getServer() {
        return this.serverConfig;
    }

    public void onConfigLoad(ModConfig modConfig) {
        if (this.client != null && modConfig.getSpec() == this.client.getSpec()) {
            this.clientConfig.watchers.forEach(AbstractConfiguration.ConfigWatcher::cacheLastValue);
        } else if (modConfig.getSpec() == this.server.getSpec()) {
            this.serverConfig.watchers.forEach(AbstractConfiguration.ConfigWatcher::cacheLastValue);
        }
    }

    public void onConfigReload(ModConfig modConfig) {
        if (this.client != null && modConfig.getSpec() == this.client.getSpec()) {
            this.clientConfig.watchers.forEach(AbstractConfiguration.ConfigWatcher::compareAndFireChangeEvent);
        } else if (modConfig.getSpec() == this.server.getSpec()) {
            this.serverConfig.watchers.forEach(AbstractConfiguration.ConfigWatcher::compareAndFireChangeEvent);
        }
    }

    public <T> void set(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
        configValue.set(value);
        this.onConfigValueEdit(configValue);
    }

    public void onConfigValueEdit(ForgeConfigSpec.ConfigValue<?> configValue) {
        for (AbstractConfiguration cfg : this.activeConfigs) {
            for (AbstractConfiguration.ConfigWatcher<?> configWatcher : cfg.watchers) {
                if (!configWatcher.sameForgeConfig(configValue)) continue;
                configWatcher.compareAndFireChangeEvent();
            }
        }
    }

    public Optional<ForgeConfigSpec.ValueSpec> getSpecFromValue(ForgeConfigSpec.ConfigValue<?> value) {
        return this.valueSpecCache.computeIfAbsent(value, key -> {
            for (ModConfig cfg : this.activeModConfigs) {
                Object patt4809$temp = cfg.getSpec().get(value.getPath());
                if (!(patt4809$temp instanceof ForgeConfigSpec.ValueSpec)) continue;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)patt4809$temp;
                return Optional.of(valueSpec);
            }
            if (!FMLEnvironment.production) {
                throw new RuntimeException("Cannot find backing ValueSpec for: " + String.valueOf(value.getPath()));
            }
            return Optional.empty();
        });
    }
}

