/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;

public class PointOfOrigin {
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation UNIVERSAL_LOCATION = new ResourceLocation("sgjourney", "universal");
    public static final ResourceLocation POINT_OF_ORIGIN_LOCATION = new ResourceLocation("sgjourney", "point_of_origin");
    public static final ResourceKey<Registry<PointOfOrigin>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)POINT_OF_ORIGIN_LOCATION);
    public static final Codec<ResourceKey<PointOfOrigin>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    public static final Codec<PointOfOrigin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PointOfOrigin::getName), (App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(PointOfOrigin::getTexture), (App)Galaxy.RESOURCE_KEY_CODEC.listOf().optionalFieldOf("generated_galaxies").forGetter(PointOfOrigin::generatedGalaxies)).apply((Applicative)instance, PointOfOrigin::new));
    private final String name;
    private final ResourceLocation texture;
    private final Optional<List<ResourceKey<Galaxy>>> generatedGalaxies;

    public PointOfOrigin(String name, ResourceLocation texture, Optional<List<ResourceKey<Galaxy>>> generatedGalaxies) {
        this.name = name;
        this.texture = texture;
        this.generatedGalaxies = generatedGalaxies;
    }

    public String getName() {
        return this.name;
    }

    private ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation texture() {
        ResourceLocation path = this.getTexture();
        ResourceLocation texture = new ResourceLocation(path.m_135827_(), "textures/symbols/" + path.m_135815_());
        if (Minecraft.m_91087_().m_91098_().m_213713_(texture).isPresent()) {
            return texture;
        }
        return ERROR_LOCATION;
    }

    public Optional<List<ResourceKey<Galaxy>>> generatedGalaxies() {
        return this.generatedGalaxies;
    }

    public static PointOfOrigin getPointOfOrigin(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (PointOfOrigin)registry.m_7745_(new ResourceLocation(split[0], split[1]));
    }

    public static ResourceKey<PointOfOrigin> defaultPointOfOrigin() {
        return Conversion.stringToPointOfOrigin("sgjourney:universal");
    }

    public static boolean validLocation(MinecraftServer server, ResourceLocation pointOfOrigin) {
        if (pointOfOrigin == null || StargateJourney.EMPTY_LOCATION.equals((Object)pointOfOrigin)) {
            return false;
        }
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry pointOfOriginRegistry = registries.m_175515_(REGISTRY_KEY);
        return pointOfOriginRegistry.m_7804_(pointOfOrigin);
    }

    public static ResourceLocation fromDimension(MinecraftServer server, ResourceKey<Level> dimension) {
        return Universe.get(server).getPointOfOrigin(dimension).m_135782_();
    }

    public static ResourceLocation randomPointOfOrigin(MinecraftServer server, ResourceKey<Level> dimension) {
        Random random = new Random();
        return Universe.get(server).getRandomPointOfOriginFromDimension(dimension, random.nextLong()).m_135782_();
    }
}

