/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.energy_cores;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.items.NaquadahFuelRodItem;
import net.povstalec.sgjourney.common.items.energy_cores.IEnergyCore;
import org.jetbrains.annotations.Nullable;

public class NaquadahGeneratorCoreItem
extends Item
implements IEnergyCore {
    public static final String REACTION_PROGRESS = "reaction_progress";

    public NaquadahGeneratorCoreItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.reactionProgress(stack) > 0L;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.reactionProgress(stack) / (float)this.getMaxReactionProgress());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.reactionProgress(stack) / (float)this.getMaxReactionProgress());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public long reactionProgress(ItemStack energyCore) {
        if (!energyCore.m_41782_() || !energyCore.m_41783_().m_128441_(REACTION_PROGRESS)) {
            return 0L;
        }
        return energyCore.m_41783_().m_128454_(REACTION_PROGRESS);
    }

    public long getMaxReactionProgress() {
        return (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_reaction_time.get();
    }

    public long doReaction(ItemStack energyCore, ItemStack input) {
        CompoundTag tag = energyCore.m_41783_();
        if (tag == null || !tag.m_128441_(REACTION_PROGRESS)) {
            return 0L;
        }
        long progress = tag.m_128454_(REACTION_PROGRESS);
        if (progress < this.getMaxReactionProgress()) {
            tag.m_128356_(REACTION_PROGRESS, ++progress);
            return this.maxGeneratedEnergy(energyCore, input);
        }
        return 0L;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.naquadah_generator_core.reaction_progress").m_7220_((Component)Component.m_237113_((String)(": " + this.reactionProgress(stack) + " / " + this.getMaxReactionProgress()))).m_130940_(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.naquadah_generator_core.description").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    @Override
    public long maxGeneratedEnergy(ItemStack energyCore, ItemStack input) {
        return (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_energy_per_tick.get();
    }

    @Override
    public long generateEnergy(ItemStack energyCore, ItemStack input) {
        long energy = this.doReaction(energyCore, input);
        if (energy == 0L && input.m_41720_() instanceof NaquadahFuelRodItem && NaquadahFuelRodItem.getFuel(input) > 0) {
            NaquadahFuelRodItem.depleteFuel(input);
            energyCore.m_41784_().m_128356_(REACTION_PROGRESS, 1L);
        }
        return energy;
    }
}

