/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;
import net.povstalec.sgjourney.common.capabilities.ItemInventoryProvider;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;
import org.jetbrains.annotations.Nullable;

public class RingRemoteItem
extends Item {
    public RingRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemInventoryProvider(stack){

            @Override
            public int getNumberOfSlots() {
                return 1;
            }

            @Override
            public boolean isValid(int slot, ItemStack stack) {
                return stack.m_150930_((Item)ItemInit.MEMORY_CRYSTAL.get());
            }
        };
    }

    protected List<TransportRingsEntity> getNearbyTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        ArrayList<TransportRingsEntity> transporters = new ArrayList<TransportRingsEntity>();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = level.m_46865_(blockPos.m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt2657$temp = level.m_7702_(pos);
                    if (patt2657$temp instanceof TransportRingsEntity) {
                        TransportRingsEntity transportRings = (TransportRingsEntity)patt2657$temp;
                        transporters.add(transportRings);
                    }
                });
            }
        }
        return transporters;
    }

    public Optional<TransportRingsEntity> findNearestTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        List<TransportRingsEntity> transporters = this.getNearbyTransportRings(level, blockPos, maxDistance);
        transporters.sort(Comparator.comparing(transporter -> blockPos.m_123331_((Vec3i)transporter.m_58899_())));
        if (!transporters.isEmpty()) {
            return Optional.of(transporters.get(0));
        }
        return Optional.empty();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() && !level.m_5776_()) {
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (offHandStack.m_150930_((Item)ItemInit.RING_REMOTE.get())) {
                offHandStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack returnStack = !mainHandStack.m_41619_() ? itemHandler.insertItem(0, mainHandStack, false) : itemHandler.extractItem(0, 1, false);
                    player.m_21008_(InteractionHand.MAIN_HAND, returnStack);
                });
            }
        } else if (!player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            if (!RingRemoteItem.canActivate(stack)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_memory_crystal").m_130940_(ChatFormatting.BLUE), true);
            } else if (!level.m_5776_()) {
                stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack crystalStack = itemHandler.getStackInSlot(0);
                    Item patt4731$temp = crystalStack.m_41720_();
                    if (patt4731$temp instanceof MemoryCrystalItem) {
                        MemoryCrystalItem crystal = (MemoryCrystalItem)patt4731$temp;
                        this.tryStartTransport(level, player, RingRemoteItem.transporterFromUUID(level, MemoryCrystalItem.getFirstUUID(crystalStack)));
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_coordinates").m_130940_(ChatFormatting.BLUE), true);
                    }
                });
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    @Nullable
    private static Transporter transporterFromUUID(Level level, UUID uuid) {
        return TransporterNetwork.get(level).getTransporter(uuid);
    }

    @Nullable
    private static Transporter transporterFromCoords(Level level, Vec3i coords) {
        BlockEntity blockEntity = level.m_7702_(new BlockPos(coords.m_123341_(), coords.m_123342_(), coords.m_123343_()));
        if (blockEntity instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
            return transporter.getTransporter();
        }
        return null;
    }

    private void tryStartTransport(Level level, Player player, @Nullable Transporter target) {
        Optional<TransportRingsEntity> transportRings = this.findNearestTransportRings(level, player.m_20183_(), 16);
        if (transportRings.isPresent()) {
            if (target != null && transportRings.get().canTransport() && transportRings.get().canTransport()) {
                transportRings.get().startTransport(target);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.transport_rings_busy").m_130940_(ChatFormatting.BLUE), true);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_transport_rings_nearby").m_130940_(ChatFormatting.BLUE), true);
        }
    }

    public static boolean canActivate(ItemStack stack) {
        if (stack.m_150930_((Item)ItemInit.RING_REMOTE.get())) {
            Optional canActivate = stack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> !itemHandler.getStackInSlot(0).m_41619_());
            return canActivate.isPresent() ? (Boolean)canActivate.get() : false;
        }
        return false;
    }

    private int[] findFirstCoords(ItemStack memoryCrystal) {
        int[] address = new int[]{};
        return address;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            ItemStack crystalStack = itemHandler.getStackInSlot(0);
            Item patt7468$temp = crystalStack.m_41720_();
            if (patt7468$temp instanceof MemoryCrystalItem) {
                MemoryCrystalItem crystal = (MemoryCrystalItem)patt7468$temp;
                tooltipComponents.add((Component)Component.m_237115_((String)"item.sgjourney.memory_crystal").m_130940_(ChatFormatting.BLUE));
                ListTag list = MemoryCrystalItem.getMemoryList(crystalStack);
                for (int i = 0; i < list.size(); ++i) {
                    tooltipComponents.add((Component)Component.m_237113_((String)("[" + i + "] ")).m_7220_(this.memoryTypeAt(level, stack, list, i)));
                }
            }
        });
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    private Component memoryTypeAt(Level level, ItemStack stack, ListTag list, int index) {
        if (list.m_128728_(index).m_128425_("address", 11)) {
            return Component.m_237115_((String)"tooltip.sgjourney.address").m_130940_(ChatFormatting.AQUA);
        }
        Vec3i coords = MemoryCrystalItem.getCoords(list, stack, index);
        if (coords != null) {
            return Component.m_237115_((String)"tooltip.sgjourney.coordinates").m_7220_((Component)Component.m_237113_((String)(" " + coords.m_123344_()))).m_130940_(ChatFormatting.BLUE);
        }
        UUID id = MemoryCrystalItem.getUUID(list, stack, index);
        if (id != null) {
            return Component.m_237113_((String)id.toString()).m_130940_(ChatFormatting.DARK_AQUA);
        }
        return Component.m_237115_((String)"tooltip.sgjourney.corrupt_data").m_130940_(ChatFormatting.DARK_RED);
    }
}

