/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemFluidHolderProvider
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final String INVENTORY_LEGACY = "Inventory";
    public static final String INVENTORY = "inventory";
    private final LazyOptional<IFluidHandlerItem> lazyFluidHandler = LazyOptional.of(() -> this);
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    @NotNull
    protected ItemStack stack;

    public ItemFluidHolderProvider(ItemStack stack) {
        this.stack = stack;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
            return this.lazyFluidHandler.cast();
        }
        return LazyOptional.empty();
    }

    public abstract boolean isValid(@Nonnull ItemStack var1);

    public ItemStack getHeldItemStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public boolean hasItem() {
        return !this.getHeldItemStack().m_41619_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ItemFluidHolderProvider.this.saveInventory();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ItemFluidHolderProvider.this.isValid(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemFluidHolderProvider.this.loadInventory();
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemFluidHolderProvider.this.loadInventory();
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                ItemFluidHolderProvider.this.loadInventory();
                this.validateSlotIndex(slot);
                return (ItemStack)this.stacks.get(slot);
            }
        };
    }

    public void loadInventory() {
        if (!this.stack.m_41782_()) {
            return;
        }
        CompoundTag tag = this.stack.m_41783_();
        if (tag.m_128441_(INVENTORY)) {
            this.itemHandler.deserializeNBT(tag.m_128469_(INVENTORY));
        } else if (tag.m_128441_(INVENTORY_LEGACY)) {
            this.itemHandler.deserializeNBT(tag.m_128469_(INVENTORY_LEGACY));
        }
    }

    public void saveInventory() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_(INVENTORY, (Tag)this.itemHandler.serializeNBT());
        this.stack.m_41751_(tag);
    }

    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }

    public int getTanks() {
        return 1;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.hasItem()) {
            return 0;
        }
        ItemStack heldStack = this.getHeldItemStack();
        IFluidHandlerItem fluidHandler = heldStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler != null) {
            int amount = fluidHandler.fill(resource, action);
            if (amount != 0) {
                this.saveInventory();
            }
            return amount;
        }
        return 0;
    }

    @NotNull
    public FluidStack deplete(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.hasItem()) {
            return FluidStack.EMPTY;
        }
        ItemStack heldStack = this.getHeldItemStack();
        IFluidHandlerItem fluidHandler = heldStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler != null) {
            FluidStack fluidStack = fluidHandler.drain(maxDrain, action);
            if (!fluidStack.isEmpty()) {
                this.saveInventory();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.stack.m_41613_() != 1 || resource.isEmpty() || !resource.isFluidEqual(this.getFluidInTank(0))) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

