/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import net.minecraft.util.StringRepresentable;

public enum ShieldingState implements StringRepresentable
{
    OPEN("open", 0),
    MOVING_1("moving_1", 20),
    MOVING_2("moving_2", 29),
    MOVING_3("moving_3", 40),
    MOVING_4("moving_4", 48),
    CLOSED("closed", 56);

    public static final short MAX_PROGRESS = 58;
    private final String name;
    private final short progress;

    private ShieldingState(String name, short progress) {
        this.name = name;
        this.progress = progress;
    }

    public String toString() {
        return this.name;
    }

    public String m_7912_() {
        return this.name;
    }

    public short getProgress() {
        return this.progress;
    }

    public boolean progressEquals(short progress) {
        return this.progress == progress;
    }

    public boolean isBefore(ShieldingState other) {
        return this.progress < other.progress;
    }

    public boolean isBefore(short otherProgress) {
        return this.progress < otherProgress;
    }

    public boolean isAfter(ShieldingState other) {
        return this.progress > other.progress;
    }

    public boolean isAfter(short otherProgress) {
        return this.progress > otherProgress;
    }

    public static ShieldingState fromProgress(short progress) {
        if (progress < ShieldingState.MOVING_1.progress) {
            return OPEN;
        }
        if (progress < ShieldingState.MOVING_2.progress) {
            return MOVING_1;
        }
        if (progress < ShieldingState.MOVING_3.progress) {
            return MOVING_2;
        }
        if (progress < ShieldingState.MOVING_4.progress) {
            return MOVING_3;
        }
        if (progress < ShieldingState.CLOSED.progress) {
            return MOVING_4;
        }
        return CLOSED;
    }
}

