/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;

public abstract class AbstractStargateRingBlock
extends AbstractStargateBlock {
    public AbstractStargateRingBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties, width, horizontalOffset);
    }

    @Override
    protected VoxelShape shape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.m_61143_((Property)ORIENTATION));
        return switch ((StargatePart)((Object)state.m_61143_((Property)PART))) {
            case StargatePart.LEFT2, StargatePart.LEFT3_ABOVE -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.CORNER_TOP_RIGHT, direction, orientation);
            case StargatePart.LEFT2_ABOVE -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_TOP_RIGHT, direction, orientation);
            case StargatePart.LEFT3_ABOVE5, StargatePart.LEFT2_ABOVE6 -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.CORNER_BOTTOM_RIGHT, direction, orientation);
            case StargatePart.LEFT2_ABOVE5 -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_BOTTOM_RIGHT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE6, StargatePart.RIGHT3_ABOVE5 -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.CORNER_BOTTOM_LEFT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE5 -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_BOTTOM_LEFT, direction, orientation);
            case StargatePart.RIGHT3_ABOVE, StargatePart.RIGHT2 -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.CORNER_TOP_LEFT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_TOP_LEFT, direction, orientation);
            case StargatePart.LEFT2_ABOVE_SHIELDED -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_TOP_RIGHT_BLOCKED, direction, orientation);
            case StargatePart.LEFT2_ABOVE5_SHIELDED -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_BOTTOM_RIGHT_BLOCKED, direction, orientation);
            case StargatePart.RIGHT2_ABOVE5_SHIELDED -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_BOTTOM_LEFT_BLOCKED, direction, orientation);
            case StargatePart.RIGHT2_ABOVE_SHIELDED -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.STAIR_TOP_LEFT_BLOCKED, direction, orientation);
            default -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.FULL, direction, orientation);
        };
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockPos baseBlockPos = ((StargatePart)((Object)oldState.m_61143_((Property)PART))).getBaseBlockPos(pos, (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_((Property)ORIENTATION)));
            this.destroyStargate(level, baseBlockPos, this.getParts(false), this.getShieldingParts(), (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_((Property)ORIENTATION)), (StargatePart)((Object)oldState.m_61143_((Property)PART)));
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    @Override
    public AbstractStargateEntity getStargate(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockEntity blockentity = reader.m_7702_(((StargatePart)((Object)state.m_61143_((Property)PART))).getBaseBlockPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION))));
        if (blockentity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
            return stargate;
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        StargatePart part = (StargatePart)((Object)state.m_61143_((Property)PART));
        BlockPos baseBlockPos = part.getBaseBlockPos(pos, (Direction)state.m_61143_((Property)FACING), (Orientation)((Object)state.m_61143_((Property)ORIENTATION)));
        Block block = level.m_8055_(baseBlockPos).m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock baseBlock = (AbstractStargateBaseBlock)block;
            return baseBlock.m_6227_(state, level, baseBlockPos, player, hand, result);
        }
        return InteractionResult.FAIL;
    }
}

