/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public abstract class CartoucheBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);

    public CartoucheBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Orientation orientation = Orientation.getOrientationFromXRot(context.m_43723_());
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(ORIENTATION, (Comparable)((Object)orientation));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{HALF}).m_61104_(new Property[]{ORIENTATION});
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Direction relativeDirection;
        Direction direction = (Direction)oldState.m_61143_((Property)f_54117_);
        Orientation orientation = (Orientation)((Object)oldState.m_61143_(ORIENTATION));
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)oldState.m_61143_(HALF);
        Direction direction2 = relativeDirection = doubleblockhalf == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockPos destroyPos = pos.m_121945_(Orientation.getMultiDirection(direction, relativeDirection, orientation));
            if (level.m_8055_(destroyPos).m_60734_() instanceof CartoucheBlock) {
                level.m_7731_(destroyPos, Blocks.f_50016_.m_49966_(), 3);
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            if (!level.m_5776_()) {
                BlockEntity blockEntity;
                Direction direction = (Direction)state.m_61143_((Property)f_54117_);
                Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
                if (level.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                    pos = pos.m_121945_(Orientation.getMultiDirection(direction, Direction.DOWN, orientation));
                }
                if ((blockEntity = level.m_7702_(pos)) instanceof CartoucheEntity) {
                    CartoucheEntity cartouche = (CartoucheEntity)blockEntity;
                    Address address = cartouche.getAddress();
                    if (address.isFromDimension()) {
                        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.dimension").m_7220_((Component)Component.m_237113_((String)": ")).m_130946_(address.getDimension().m_135782_().toString()).m_130940_(ChatFormatting.GREEN));
                    }
                    player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.address").m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.YELLOW).m_7220_(address.toComponent(true)));
                    if (cartouche.getSymbols() != null) {
                        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)(": " + cartouche.getSymbols()))).m_130940_(ChatFormatting.LIGHT_PURPLE));
                    }
                    if (cartouche.getAddressTable() != null) {
                        player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.address_table").m_7220_((Component)Component.m_237113_((String)(": " + cartouche.getAddressTable()))).m_130940_(ChatFormatting.YELLOW));
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract ItemLike getItem();

    public abstract Block getBlock();

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockpos = pos.m_121945_(Orientation.getCenterDirection(direction, orientation));
        level.m_7731_(blockpos, (BlockState)((BlockState)((BlockState)this.getBlock().m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_(ORIENTATION, (Comparable)((Object)orientation))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            pos = pos.m_121945_(Orientation.getMultiDirection(direction, Direction.DOWN, orientation));
        }
        if ((blockentity = level.m_7702_(pos)) instanceof CartoucheEntity && !level.m_5776_() && !player.m_7500_() && player.m_36298_(state)) {
            ItemStack itemstack = new ItemStack(this.getItem());
            blockentity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return (localLevel, pos, blockState, entity) -> {
                if (entity instanceof CartoucheEntity) {
                    CartoucheEntity cartouche = (CartoucheEntity)entity;
                    cartouche.tick(localLevel, pos, blockState);
                }
            };
        }
        return null;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        boolean hasAddress = false;
        String dimension = "";
        String symbols = "";
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null) {
            if (blockEntityTag.m_128441_("Address")) {
                hasAddress = true;
                int[] addressArray = blockEntityTag.m_128465_("Address");
                Address address = new Address(addressArray);
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.address").m_7220_((Component)Component.m_237113_((String)": ").m_7220_(address.toComponent(false))).m_130940_(ChatFormatting.YELLOW));
            }
            if (blockEntityTag.m_128441_("Dimension")) {
                dimension = blockEntityTag.m_128461_("Dimension");
            }
            if (blockEntityTag.m_128441_("Symbols")) {
                Minecraft minecraft = Minecraft.m_91087_();
                ClientPacketListener clientPacketListener = minecraft.m_91403_();
                RegistryAccess registries = clientPacketListener.m_105152_();
                Registry symbolsRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
                ResourceLocation location = new ResourceLocation(blockEntityTag.m_128461_("Symbols"));
                symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.m_7804_(location) ? ((Symbols)symbolsRegistry.m_7745_(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
            }
            if (blockEntityTag.m_128441_("AddressTable")) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.address_table").m_7220_((Component)Component.m_237113_((String)(": " + blockEntityTag.m_128461_("AddressTable")))).m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (!hasAddress) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.dimension").m_7220_((Component)Component.m_237113_((String)(": " + dimension))).m_130940_(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.m_237115_((String)Symbols.symbolsOrSet()).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)symbols)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128425_("generation_step", 1) && StructureGenEntity.Step.SETUP == StructureGenEntity.Step.fromByte(stack.m_41783_().m_128469_("BlockEntityTag").m_128445_("generation_step"))) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.generates_inside_structure").m_130940_(ChatFormatting.YELLOW));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static class RedSandstone
    extends CartoucheBlock {
        public RedSandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.RedSandstone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.RED_SANDSTONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.RED_SANDSTONE_CARTOUCHE.get();
        }
    }

    public static class Sandstone
    extends CartoucheBlock {
        public Sandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.Sandstone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.SANDSTONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.SANDSTONE_CARTOUCHE.get();
        }
    }

    public static class Stone
    extends CartoucheBlock {
        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
                return null;
            }
            return new CartoucheEntity.Stone(pos, state);
        }

        @Override
        public Block getBlock() {
            return (Block)BlockInit.STONE_CARTOUCHE.get();
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.STONE_CARTOUCHE.get();
        }
    }
}

