/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech_interface;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.BasicInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.capabilities.CCTweakedCapabilities;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.InterfacePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundInterfaceUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInterfaceEntity
extends EnergyBlockEntity {
    public static final String ENERGY_TARGET = "EnergyTarget";
    public int signalStrength = 0;
    private int desiredSymbol = 0;
    private int currentSymbol = 0;
    private boolean rotate = false;
    private boolean rotateClockwise = true;
    private StargateInfo.IrisMotion irisMotion = StargateInfo.IrisMotion.IDLE;
    private long energyTarget = (Long)CommonInterfaceConfig.default_energy_target.get();
    protected boolean requiresUpdate = true;
    @Nullable
    protected EnergyBlockEntity energyBlockEntity = null;
    protected InterfacePeripheralWrapper peripheralWrapper;
    protected InterfaceType interfaceType;

    public AbstractInterfaceEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InterfaceType interfaceType) {
        super(type, pos, state);
        this.interfaceType = interfaceType;
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralWrapper = new InterfacePeripheralWrapper(this);
        }
    }

    @Override
    public void onLoad() {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58904_().m_8055_(pos);
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof AbstractInterfaceBlock) {
            AbstractInterfaceBlock interfaceBlock = (AbstractInterfaceBlock)block;
            interfaceBlock.updateInterface(state, level, pos);
        }
        super.onLoad();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyTarget = tag.m_128454_(ENERGY_TARGET);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128356_(ENERGY_TARGET, this.energyTarget);
        super.m_183515_(tag);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ModList.get().isLoaded("computercraft") && cap == CCTweakedCapabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheralWrapper.newPeripheral().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean updateInterface(Level level, BlockPos pos, Block block, BlockState state) {
        this.requiresUpdate = true;
        if (this.peripheralWrapper != null) {
            return this.peripheralWrapper.resetInterface();
        }
        Block block2 = level.m_8055_(pos).m_60734_();
        if (block2 instanceof AbstractInterfaceBlock) {
            AbstractInterfaceBlock ccInterface = (AbstractInterfaceBlock)block2;
            ccInterface.updateInterface(state, level, pos);
        }
        return true;
    }

    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractInterfaceBlock) {
            return (Direction)gateState.m_61143_((Property)AbstractInterfaceBlock.FACING);
        }
        StargateJourney.LOGGER.error("Couldn't find Direction " + this.m_58899_().toString());
        return null;
    }

    public InterfaceMode getMode() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60734_() instanceof AbstractInterfaceBlock) {
            return (InterfaceMode)((Object)state.m_61143_(AbstractInterfaceBlock.MODE));
        }
        return InterfaceMode.OFF;
    }

    @Nullable
    public EnergyBlockEntity findEnergyBlockEntity() {
        Direction direction = this.getDirection();
        if (direction == null) {
            return null;
        }
        BlockPos realPos = this.m_58899_().m_121945_(direction);
        BlockState state = this.f_58857_.m_8055_(realPos);
        Block block = this.f_58857_.m_8055_(realPos).m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            return stargateBlock.getStargate((BlockGetter)this.f_58857_, realPos, state);
        }
        return null;
    }

    public EnergyBlockEntity getEnergyBlockEntity() {
        if (this.energyBlockEntity == null && this.requiresUpdate) {
            this.requiresUpdate = false;
            this.energyBlockEntity = this.findEnergyBlockEntity();
        }
        return this.energyBlockEntity;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public int getStargateOpenTime() {
        EnergyBlockEntity energyBlockEntity = this.getEnergyBlockEntity();
        if (energyBlockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
            return stargate.getOpenTime();
        }
        return -1;
    }

    public int getStargateTimeSinceLastTraveler() {
        EnergyBlockEntity energyBlockEntity = this.getEnergyBlockEntity();
        if (energyBlockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
            return stargate.getTimeSinceLastTraveler();
        }
        return -1;
    }

    public long getEnergyBlockEnergy() {
        if (this.getEnergyBlockEntity() == null) {
            return -1L;
        }
        return this.getEnergyBlockEntity().getEnergyStored();
    }

    @Override
    protected boolean canReceiveZeroPointEnergy() {
        return (Boolean)CommonZPMConfig.stargates_use_zero_point_energy.get();
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return side != this.getDirection();
    }

    @Override
    protected boolean outputsEnergy() {
        return true;
    }

    @Override
    protected boolean receivesEnergy() {
        return true;
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        if (this.getEnergyBlockEntity().getEnergyStored() >= this.getEnergyTarget()) {
            return;
        }
        long needed = SGJourneyEnergy.energyToTarget(this.getEnergyTarget(), this.getEnergyBlockEntity().getEnergyStored(), this.maxExtract());
        long simulatedOutputAmount = this.ENERGY_STORAGE.extractLongEnergy(needed, true);
        long simulatedReceiveAmount = this.getEnergyBlockEntity().ENERGY_STORAGE.receiveLongEnergy(simulatedOutputAmount, true);
        this.ENERGY_STORAGE.extractLongEnergy(simulatedReceiveAmount, false);
        this.getEnergyBlockEntity().ENERGY_STORAGE.receiveLongEnergy(simulatedReceiveAmount, false);
    }

    public long getEnergyTarget() {
        return this.energyTarget;
    }

    public void setEnergyTarget(long energyTarget) {
        this.energyTarget = energyTarget;
    }

    public InterfacePeripheralWrapper getPeripheralWrapper() {
        if (!ModList.get().isLoaded("computercraft")) {
            return null;
        }
        return this.peripheralWrapper;
    }

    public void queueEvent(String eventName, Object ... objects) {
        if (!ModList.get().isLoaded("computercraft")) {
            return;
        }
        if (this.peripheralWrapper != null) {
            this.peripheralWrapper.queueEvent(eventName, objects);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractInterfaceEntity interfaceEntity) {
        if (interfaceEntity.getEnergyBlockEntity() != null) {
            int lastSymbol = interfaceEntity.currentSymbol;
            interfaceEntity.outputEnergy(interfaceEntity.getDirection());
            EnergyBlockEntity energyBlockEntity = interfaceEntity.getEnergyBlockEntity();
            if (energyBlockEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
                interfaceEntity.handleShielding(state, stargate);
                if (stargate instanceof RotatingStargateEntity) {
                    RotatingStargateEntity rotatingStargate = (RotatingStargateEntity)stargate;
                    interfaceEntity.rotateStargate(rotatingStargate);
                }
            }
            if (lastSymbol != interfaceEntity.currentSymbol && !level.m_5776_()) {
                AbstractInterfaceEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                level.m_46590_(pos, state.m_60734_(), (Direction)state.m_61143_((Property)AbstractInterfaceBlock.FACING));
            }
        }
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(interfaceEntity.f_58858_)), (Object)new ClientboundInterfaceUpdatePacket(interfaceEntity.f_58858_, interfaceEntity.getEnergyStored(), interfaceEntity.getEnergyTarget()));
    }

    private void rotateStargate(RotatingStargateEntity stargate) {
        if (this.rotate) {
            if (stargate.isCurrentSymbol(this.desiredSymbol)) {
                this.rotate = false;
            } else {
                stargate.rotate(this.rotateClockwise);
            }
        }
        this.currentSymbol = stargate.getCurrentSymbol();
    }

    protected void handleShielding(BlockState state, AbstractStargateEntity stargate) {
        this.handleRedstone(state, stargate);
        if (stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            this.handleIris(irisStargate);
        }
    }

    private boolean belowMaxProgress(IrisStargateEntity stargate) {
        return stargate.irisInfo().getIrisProgress() < 58;
    }

    private boolean aboveMinProgress(IrisStargateEntity stargate) {
        return stargate.irisInfo().getIrisProgress() > 0;
    }

    protected void handleRedstone(BlockState state, AbstractStargateEntity stargate) {
        InterfaceMode mode = (InterfaceMode)((Object)state.m_61143_((Property)BasicInterfaceBlock.MODE));
        if (mode != InterfaceMode.IRIS || !this.irisMotion.isRedstone()) {
            return;
        }
        if (stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            if (this.signalStrength == 0 && this.irisMotion != StargateInfo.IrisMotion.IDLE) {
                this.setIrisMotion(StargateInfo.IrisMotion.IDLE);
            } else if (this.signalStrength > 0 && this.signalStrength <= 7 && this.irisMotion != StargateInfo.IrisMotion.CLOSING_REDSTONE && this.belowMaxProgress(irisStargate)) {
                this.setIrisMotion(StargateInfo.IrisMotion.CLOSING_REDSTONE);
            } else if (this.signalStrength >= 8 && this.signalStrength <= 15 && this.irisMotion != StargateInfo.IrisMotion.OPENING_REDSTONE && this.aboveMinProgress(irisStargate)) {
                this.setIrisMotion(StargateInfo.IrisMotion.OPENING_REDSTONE);
            }
        }
    }

    protected void handleIris(IrisStargateEntity stargate) {
        if (this.irisMotion.isClosing()) {
            if (this.belowMaxProgress(stargate)) {
                stargate.irisInfo().increaseIrisProgress();
            } else {
                this.irisMotion = StargateInfo.IrisMotion.IDLE;
            }
        } else if (this.irisMotion.isOpening()) {
            if (this.aboveMinProgress(stargate)) {
                stargate.irisInfo().decreaseIrisProgress();
            } else {
                this.irisMotion = StargateInfo.IrisMotion.IDLE;
            }
        }
    }

    public boolean setIrisMotion(StargateInfo.IrisMotion irisMotion) {
        if (this.irisMotion == irisMotion) {
            return false;
        }
        this.irisMotion = irisMotion;
        return true;
    }

    public static enum InterfaceType {
        BASIC("basic_interface"),
        CRYSTAL("crystal_interface"),
        ADVANCED_CRYSTAL("advanced_crystal_interface");

        private String typeName;

        private InterfaceType(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.typeName;
        }

        public boolean hasCrystalMethods() {
            return this == CRYSTAL || this == ADVANCED_CRYSTAL;
        }

        public boolean hasAdvancedCrystalMethods() {
            return this == ADVANCED_CRYSTAL;
        }
    }
}

