/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.tech.TransceiverBlock;
import net.povstalec.sgjourney.common.capabilities.CCTweakedCapabilities;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.TransceiverPeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.packets.ClientboundTransceiverUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.ITransmissionReceiver;
import org.jetbrains.annotations.NotNull;

public class TransceiverEntity
extends BlockEntity
implements ITransmissionReceiver {
    public static final String IDC = "idc";
    public static final String FREQUENCY = "frequency";
    public static final String EDIT_FREQUENCY = "edit_frequency";
    private static final String EVENT_TRANSMISSION_RECEIVED = "transceiver_transmission_received";
    private static final short MAX_TRANSMISSION_TICKS = 20;
    private boolean editingFrequency = false;
    private int frequency = 0;
    private String idc = "";
    private short transmissionTicks = 0;
    protected TransceiverPeripheralWrapper peripheralWrapper;

    public TransceiverEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSCEIVER.get(), pos, state);
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralWrapper = new TransceiverPeripheralWrapper(this);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.editingFrequency = tag.m_128471_(EDIT_FREQUENCY);
        this.frequency = tag.m_128451_(FREQUENCY);
        this.idc = tag.m_128461_(IDC);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_(EDIT_FREQUENCY, this.editingFrequency);
        tag.m_128405_(FREQUENCY, this.frequency);
        tag.m_128359_(IDC, this.idc);
    }

    public float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_transceiver_transmission_distance.get()).intValue();
    }

    public float transmissionRadiusSqr() {
        return this.transmissionRadius() * this.transmissionRadius();
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
        this.m_6596_();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setEditingFrequency(boolean editingFrequency) {
        this.editingFrequency = editingFrequency;
    }

    public boolean editingFrequency() {
        return this.editingFrequency;
    }

    public void setCurrentCode(String idc) {
        this.idc = idc;
        this.m_6596_();
    }

    public String getCurrentCode() {
        return this.idc;
    }

    public void toggleFrequency() {
        this.editingFrequency = !this.editingFrequency;
        this.m_6596_();
    }

    @Override
    public void receiveTransmission(int transmissionJumps, int frequency, String transmission) {
        if (this.f_58857_.m_5776_() || frequency != this.getFrequency()) {
            return;
        }
        boolean codeIsCorrect = this.getCurrentCode().equals(transmission);
        this.queueEvent(EVENT_TRANSMISSION_RECEIVED, frequency, transmission, codeIsCorrect);
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof TransceiverBlock) {
            TransceiverBlock transceiver = (TransceiverBlock)block;
            transceiver.receiveTransmission(state, level, pos, codeIsCorrect);
        }
    }

    public void sendTransmission() {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        if (blockEntity != this) {
                            receiver.receiveTransmission(0, this.getFrequency(), this.getCurrentCode());
                        }
                    }
                });
            }
        }
        Level level = this.m_58904_();
        BlockPos pos2 = this.m_58899_();
        BlockState state = this.m_58900_();
        level.m_7731_(pos2, (BlockState)state.m_61124_((Property)TransceiverBlock.TRANSMITTING, (Comparable)Boolean.valueOf(true)), 2);
        this.transmissionTicks = (short)20;
    }

    public int checkShieldingState() {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        ArrayList stargates = new ArrayList();
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt5875$temp = this.f_58857_.m_7702_(pos);
                    if (patt5875$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt5875$temp;
                        if ((float)CoordinateHelper.Relative.distanceSqr((Vec3i)this.m_58899_(), (Vec3i)stargate.m_58899_()) <= this.transmissionRadiusSqr()) {
                            stargates.add(stargate);
                        }
                    }
                });
            }
        }
        if (stargates.size() == 0) {
            return -1;
        }
        stargates.sort((stargateA, stargateB) -> Double.valueOf(CoordinateHelper.Relative.distanceSqr((Vec3i)this.m_58899_(), (Vec3i)stargateA.m_58899_())).compareTo(Double.valueOf(CoordinateHelper.Relative.distanceSqr((Vec3i)this.m_58899_(), (Vec3i)stargateB.m_58899_()))));
        AbstractStargateEntity stargate = (AbstractStargateEntity)stargates.get(0);
        if (!stargate.isConnected()) {
            return -2;
        }
        return Math.round(stargate.checkConnectionShieldingState());
    }

    public void addToCode(int number) {
        if (!this.editingFrequency) {
            if (this.idc.length() >= 16) {
                return;
            }
            this.idc = this.idc + String.valueOf(number);
        } else {
            long tempFrequency = this.frequency;
            if ((tempFrequency = tempFrequency * 10L + (long)number) > Integer.MAX_VALUE) {
                return;
            }
            this.frequency = (int)tempFrequency;
        }
        this.m_6596_();
    }

    public void removeFromCode() {
        if (!this.editingFrequency) {
            if (this.idc.length() <= 0) {
                return;
            }
            this.idc = this.idc.substring(0, this.idc.length() - 1);
        } else {
            if (this.frequency <= 0) {
                return;
            }
            this.frequency /= 10;
        }
        this.m_6596_();
    }

    public void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundTransceiverUpdatePacket(this.f_58858_, this.editingFrequency, this.frequency, this.idc));
    }

    public TransceiverPeripheralWrapper getPeripheralWrapper() {
        if (!ModList.get().isLoaded("computercraft")) {
            return null;
        }
        return this.peripheralWrapper;
    }

    public void queueEvent(String eventName, Object ... objects) {
        if (!ModList.get().isLoaded("computercraft")) {
            return;
        }
        if (this.peripheralWrapper != null) {
            this.peripheralWrapper.queueEvent(eventName, objects);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ModList.get().isLoaded("computercraft") && cap == CCTweakedCapabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheralWrapper.newPeripheral().cast();
        }
        return super.getCapability(cap, side);
    }

    private void handleTransmissionTicks() {
        if (this.transmissionTicks > 0) {
            this.transmissionTicks = (short)(this.transmissionTicks - 1);
            if (this.transmissionTicks == 0) {
                Level level = this.m_58904_();
                BlockPos pos = this.m_58899_();
                BlockState state = this.m_58900_();
                Block block = state.m_60734_();
                if (block instanceof TransceiverBlock) {
                    TransceiverBlock transceiver = (TransceiverBlock)block;
                    transceiver.stopTransmitting(state, level, pos);
                }
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TransceiverEntity transceiver) {
        transceiver.handleTransmissionTicks();
        transceiver.updateClient();
    }
}

