/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.povstalec.sgjourney.client.screens.SGJourneyContainerScreen;
import net.povstalec.sgjourney.client.widgets.InterfaceModeButton;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.menu.InterfaceMenu;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class InterfaceScreen
extends SGJourneyContainerScreen<InterfaceMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("sgjourney", "textures/gui/interface_gui.png");
    protected EditBox commandEdit;

    public InterfaceScreen(InterfaceMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public static long parsePositiveOrZero(String text) {
        try {
            long value = Long.parseLong(text);
            return value > 0L ? value : 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected boolean isShiftDown() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
    }

    public InterfaceMode getMode() {
        return ((InterfaceMenu)this.f_97732_).getMode();
    }

    protected void m_7856_() {
        this.commandEdit = new EditBox(this.f_96547_, this.f_96543_ / 2 - 54, this.f_96544_ / 2 - 66, 124, 20, (Component)Component.m_237115_((String)"tooltip.sgjourney.energy_target"));
        this.commandEdit.m_94153_(text -> {
            if (text.isEmpty()) {
                return true;
            }
            try {
                return Long.parseLong(text) >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.commandEdit.m_94199_(19);
        this.m_7787_((GuiEventListener)this.commandEdit);
        this.m_264313_((GuiEventListener)this.commandEdit);
        this.commandEdit.m_94151_(text -> ((InterfaceMenu)this.f_97732_).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(text), ((InterfaceMenu)this.f_97732_).getMode()));
        this.commandEdit.m_94144_(String.valueOf(((InterfaceMenu)this.f_97732_).getEnergyTarget()));
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)new InterfaceModeButton(x + 9, y + 19, (Component)Component.m_237119_(), (Component)Component.m_237119_(), button -> {
            if (this.isShiftDown()) {
                ((InterfaceMenu)this.f_97732_).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(this.commandEdit.m_94155_()), ((InterfaceMenu)this.f_97732_).getMode().previous(((InterfaceMenu)this.f_97732_).getInterfaceType().hasAdvancedCrystalMethods()));
            } else {
                ((InterfaceMenu)this.f_97732_).setEnergyTargetAndMode(InterfaceScreen.parsePositiveOrZero(this.commandEdit.m_94155_()), ((InterfaceMenu)this.f_97732_).getMode().next(((InterfaceMenu)this.f_97732_).getInterfaceType().hasAdvancedCrystalMethods()));
            }
        }, this));
        super.m_7856_();
    }

    protected void m_7286_(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyVertical(graphics, TEXTURE, x + 162, y + 17, 6, 138, 176, 0, ((InterfaceMenu)this.f_97732_).getEnergy(), ((InterfaceMenu)this.f_97732_).getMaxEnergy());
    }

    protected void modeTooltip(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, Component name, Component ... components) {
        if (this.m_6774_(x, y, width, height, mouseX, mouseY)) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add(name);
            tooltips.addAll(List.of(components));
            graphics.m_280666_(this.f_96547_, tooltips, mouseX, mouseY);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.commandEdit.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        this.tooltip(graphics, mouseX, mouseY, 33, 16, 126, 20, new Component[]{ComponentHelper.energy("tooltip.sgjourney.energy_target", ((InterfaceMenu)this.f_97732_).getEnergyTarget()), ComponentHelper.description("tooltip.sgjourney.interface.energy_target.description")});
        this.energyTooltip(graphics, mouseX, mouseY, 162, 17, 6, 138, "tooltip.sgjourney.energy_buffer", ((InterfaceMenu)this.f_97732_).getEnergy(), ((InterfaceMenu)this.f_97732_).getMaxEnergy());
        this.modeTooltip(graphics, mouseX, mouseY, 9, 19, 16, 16, (Component)Component.m_237115_((String)"block.sgjourney.interface.mode").m_130946_(": ").m_7220_(((InterfaceMenu)this.f_97732_).getMode().getName()), ((InterfaceMenu)this.f_97732_).getMode().getUsage());
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)ComponentHelper.energy(((InterfaceMenu)this.f_97732_).getEnergyBlockEnergy()), 20, 56, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"info.sgjourney.open_time").m_130946_(":").m_130940_(ChatFormatting.DARK_AQUA), 20, 66, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)ComponentHelper.tickTimer(((InterfaceMenu)this.f_97732_).getStargateOpenTime(), Stargate.getMaxGateOpenTime(), ChatFormatting.DARK_AQUA), 20, 76, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"info.sgjourney.last_traveler_time").m_130946_(":").m_130940_(ChatFormatting.DARK_PURPLE), 20, 86, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)Conversion.ticksToString(((InterfaceMenu)this.f_97732_).getStargateTimeSinceLastTraveler())).m_130940_(ChatFormatting.DARK_PURPLE), 20, 96, 0xFFFFFF, false);
    }
}

