/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.povstalec.sgjourney.client.Layers;
import net.povstalec.sgjourney.client.models.block_entity.TransportRingsModel;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;

public class TransportRingsRenderer
implements BlockEntityRenderer<TransportRingsEntity> {
    protected final TransportRingsModel transportRings;

    public TransportRingsRenderer(BlockEntityRendererProvider.Context context) {
        this.transportRings = new TransportRingsModel(context.m_173582_(Layers.TRANSPORT_RING_LAYER));
    }

    private float getProgress(TransportRingsEntity rings, float partialTick) {
        int maxProgress;
        float progress = rings.getProgress(partialTick);
        if (progress > (float)(maxProgress = rings.getTransportHeight() + 60)) {
            return (float)(2 * maxProgress - 30) - progress;
        }
        return progress;
    }

    private float ringHeight(TransportRingsEntity rings, int ringNumber, float partialTick) {
        float height = this.getProgress(rings, partialTick) - (float)(6 * ringNumber);
        return 4.0f * (rings.emptySpace >= 0 ? height : -height);
    }

    private float stopHeight(TransportRingsEntity rings, int ringNumber) {
        float height = rings.getTransportHeight() - 2 * ringNumber;
        return 4.0f * (rings.emptySpace >= 0 ? height : -height);
    }

    private float getHeight(TransportRingsEntity rings, int ringNumber, float partialTick) {
        int startTicks;
        float progress = this.getProgress(rings, partialTick);
        if (progress <= (float)(startTicks = 6 * ringNumber)) {
            return 0.0f;
        }
        float ringHeight = this.ringHeight(rings, ringNumber, partialTick);
        float stopHeight = this.stopHeight(rings, ringNumber);
        if (rings.emptySpace >= 0 && ringHeight >= stopHeight || rings.emptySpace < 0 && ringHeight <= stopHeight) {
            return stopHeight;
        }
        return ringHeight;
    }

    public void render(TransportRingsEntity rings, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        this.transportRings.setRingHeight(1, this.getHeight(rings, 0, partialTick));
        this.transportRings.setRingHeight(2, this.getHeight(rings, 1, partialTick));
        this.transportRings.setRingHeight(3, this.getHeight(rings, 2, partialTick));
        this.transportRings.setRingHeight(4, this.getHeight(rings, 3, partialTick));
        this.transportRings.setRingHeight(5, this.getHeight(rings, 4, partialTick));
        this.transportRings.renderTransportRings(rings, partialTick, stack, source, combinedLight, combinedOverlay);
        stack.m_85849_();
    }
}

