/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.sgjourney.info.IrisInfo;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class IrisModel {
    private static final float OFFSET = 0.03125f;
    private static final int TOTAL_SIDES = 20;
    private static final float DEGREES = 18.0f;
    public static final float IRIS_TEXTURE_WIDTH = 256.0f;
    public static final float IRIS_TEXTURE_HEIGHT = 256.0f;
    public static final float IRIS_BLADE_WIDTH = 0.792f;
    public static final float IRIS_BLADE_WIDTH_HALF = 0.396f;
    public static final float IRIS_BLADE_LENGTH = 2.5f;
    public static final float IRIS_BLADE_HEIGHT = 40.0f;
    public static final float IRIS_OPEN_DEGREES = 84.0f;
    public static final float IRIS_ROTATE_DEGREES = 1.0f;
    public static final float TEXTURE_CENTER_U = 0.025390625f;
    public static final float TEXTURE_TOP_V = 0.0f;
    public static final float TEXTURE_LEFT_U = 6.4062513E-4f;
    public static final float TEXTURE_LEFT_V = 0.15625f;
    public static final float TEXTURE_RIGHT_U = 0.050140627f;
    public static final float TEXTURE_RIGHT_V = 0.15625f;
    private boolean renderWhenOpen;
    private float maxOpenDegrees;

    public IrisModel(boolean renderWhenOpen, float maxOpenDegrees) {
        this.renderWhenOpen = renderWhenOpen;
        this.maxOpenDegrees = maxOpenDegrees;
    }

    public void renderIris(IrisInfo.Interface irisStargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, float progress) {
        float closingProgress = (58.0f - progress) / 58.0f;
        Optional<ResourceLocation> irisTexture = irisStargate.irisInfo().getIrisTexture();
        if (!this.renderWhenOpen && progress == 0.0f || irisTexture.isEmpty()) {
            return;
        }
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.iris(irisTexture.get()));
        stack.m_85836_();
        for (int j = 0; j < 20; ++j) {
            stack.m_85836_();
            stack.m_252880_(0.396f, 2.5f, 0.0f);
            stack.m_252781_(Axis.f_252436_.m_252977_(-1.0f * closingProgress));
            stack.m_252781_(Axis.f_252403_.m_252977_(-this.maxOpenDegrees * closingProgress));
            Matrix4f matrix4 = stack.m_85850_().m_252922_();
            Matrix3f matrix3 = stack.m_85850_().m_252943_();
            float uAddition = (float)(13 * (j % 10)) / 256.0f;
            float vAddition = (float)(40 * (j / 10)) / 256.0f;
            SGJourneyModel.createTriangle(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.792f, 0.0f, 0.03125f, 0.050140627f + uAddition, 0.15625f + vAddition, -0.396f, -2.5f, 0.03125f, 0.025390625f + uAddition, 0.0f + vAddition, 0.0f, 0.0f, 0.03125f, 6.4062513E-4f + uAddition, 0.15625f + vAddition);
            SGJourneyModel.createTriangle(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, -0.396f, -2.5f, 0.03125f, 0.025390625f + uAddition, 0.0f + vAddition, -0.792f, 0.0f, 0.03125f, 0.050140627f + uAddition, 0.15625f + vAddition, 0.0f, 0.0f, 0.03125f, 6.4062513E-4f + uAddition, 0.15625f + vAddition);
            stack.m_85849_();
            stack.m_252781_(Axis.f_252403_.m_252977_(18.0f));
        }
        stack.m_85849_();
    }
}

