/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.common.block;

import cofh.core.common.network.packet.client.ModelUpdatePacket;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.block.IDismantleable;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.raytracer.IndexedVoxelShape;
import cofh.lib.util.raytracer.MultiIndexedVoxelShape;
import cofh.lib.util.raytracer.RayTracer;
import cofh.lib.util.raytracer.VoxelShapeBlockHitResult;
import cofh.thermal.core.common.item.RedprintItem;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.api.grid.IGridHostLuminous;
import cofh.thermal.dynamics.common.block.entity.duct.DuctBlockEntity;
import cofh.thermal.dynamics.common.item.AttachmentItem;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DuctBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock,
IDismantleable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Int2ObjectMap<MultiIndexedVoxelShape> SHAPE_CACHE = new Int2ObjectOpenHashMap(512);
    private static final IndexedVoxelShape BASE_SHAPE = new IndexedVoxelShape(Block.m_49796_((double)4.5, (double)4.5, (double)4.5, (double)11.5, (double)11.5, (double)11.5), (Object)0);
    private static final IndexedVoxelShape[] INTERNAL_CONNECTION = new IndexedVoxelShape[]{new IndexedVoxelShape(Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)4.5, (double)11.5), (Object)1), new IndexedVoxelShape(Block.m_49796_((double)4.5, (double)11.5, (double)4.5, (double)11.5, (double)16.0, (double)11.5), (Object)2), new IndexedVoxelShape(Block.m_49796_((double)4.5, (double)4.5, (double)0.0, (double)11.5, (double)11.5, (double)4.5), (Object)3), new IndexedVoxelShape(Block.m_49796_((double)4.5, (double)4.5, (double)11.5, (double)11.5, (double)11.5, (double)16.0), (Object)4), new IndexedVoxelShape(Block.m_49796_((double)0.0, (double)4.5, (double)4.5, (double)4.5, (double)11.5, (double)11.5), (Object)5), new IndexedVoxelShape(Block.m_49796_((double)11.5, (double)4.5, (double)4.5, (double)16.0, (double)11.5, (double)11.5), (Object)6)};
    private static final IndexedVoxelShape[] EXTERNAL_CONNECTION = new IndexedVoxelShape[]{new IndexedVoxelShape(Block.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)4.5, (double)12.5), (Object)7), new IndexedVoxelShape(Block.m_49796_((double)3.5, (double)11.5, (double)3.5, (double)12.5, (double)16.0, (double)12.5), (Object)8), new IndexedVoxelShape(Block.m_49796_((double)3.5, (double)3.5, (double)0.0, (double)12.5, (double)12.5, (double)4.5), (Object)9), new IndexedVoxelShape(Block.m_49796_((double)3.5, (double)3.5, (double)11.5, (double)12.5, (double)12.5, (double)16.0), (Object)10), new IndexedVoxelShape(Block.m_49796_((double)0.0, (double)3.5, (double)3.5, (double)4.5, (double)12.5, (double)12.5), (Object)11), new IndexedVoxelShape(Block.m_49796_((double)11.5, (double)3.5, (double)3.5, (double)16.0, (double)12.5, (double)12.5), (Object)12)};
    protected final Supplier<BlockEntityType<?>> blockEntityType;

    public DuctBlock(BlockBehaviour.Properties builder, Supplier<BlockEntityType<?>> blockEntityType) {
        super(builder);
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape getConnectionShape(int connectionState) {
        if (SHAPE_CACHE.containsKey(connectionState)) {
            return (VoxelShape)SHAPE_CACHE.get(connectionState);
        }
        ImmutableSet.Builder cuboids = ImmutableSet.builder();
        cuboids.add((Object)BASE_SHAPE);
        for (int i = 0; i < 6; ++i) {
            if ((connectionState & 1 << i + 6) > 0) {
                cuboids.add((Object)EXTERNAL_CONNECTION[i]);
                continue;
            }
            if ((connectionState & 1 << i) <= 0) continue;
            cuboids.add((Object)INTERNAL_CONNECTION[i]);
        }
        MultiIndexedVoxelShape retShape = new MultiIndexedVoxelShape(cuboids.build());
        SHAPE_CACHE.put(connectionState, (Object)retShape);
        return retShape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof DuctBlockEntity) {
            DuctBlockEntity duct = (DuctBlockEntity)blockEntity;
            duct.calcDuctModelDataServer();
            BlockHitResult rawHit = RayTracer.retrace((Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (rawHit instanceof VoxelShapeBlockHitResult) {
                VoxelShapeBlockHitResult advHit = (VoxelShapeBlockHitResult)rawHit;
                ItemStack heldStack = player.m_21120_(handIn);
                if (Utils.isWrench((ItemStack)heldStack)) {
                    if (Utils.isClientWorld((Level)worldIn)) {
                        return InteractionResult.SUCCESS;
                    }
                    if (advHit.subHit == 0) {
                        duct.attemptConnect(advHit.m_82434_());
                    } else if (advHit.subHit < 7) {
                        duct.attemptDisconnect(Constants.DIRECTIONS[advHit.subHit - 1], player);
                    } else if (advHit.subHit < 13) {
                        duct.attemptDisconnect(Constants.DIRECTIONS[advHit.subHit - 7], player);
                    }
                    return InteractionResult.CONSUME;
                }
                if (heldStack.m_41720_() instanceof RedprintItem) {
                    if (Utils.isClientWorld((Level)worldIn)) {
                        return InteractionResult.SUCCESS;
                    }
                    if (advHit.subHit >= 7 && duct.attachmentRedprintInteraction(heldStack, Constants.DIRECTIONS[advHit.subHit - 7], player)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (heldStack.m_41619_()) {
                        if (Utils.isClientWorld((Level)worldIn)) {
                            return InteractionResult.SUCCESS;
                        }
                        if (advHit.subHit >= 7 ? duct.openAttachmentGui(Constants.DIRECTIONS[advHit.subHit - 7], player) : duct.openDuctGui(player)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.CONSUME;
                    }
                    Item item = heldStack.m_41720_();
                    if (item instanceof AttachmentItem) {
                        AttachmentItem attachmentItem = (AttachmentItem)item;
                        if (Utils.isClientWorld((Level)worldIn)) {
                            return InteractionResult.SUCCESS;
                        }
                        if (advHit.subHit == 0) {
                            if (duct.attemptAttachmentInstall(advHit.m_82434_(), player, attachmentItem.getAttachmentType(heldStack))) {
                                if (!player.m_150110_().f_35937_) {
                                    player.m_21008_(handIn, ItemHelper.consumeItem((ItemStack)heldStack, (int)1));
                                }
                            } else {
                                duct.openDuctGui(player);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (advHit.subHit >= 7) {
                            if (duct.attemptAttachmentInstall(Constants.DIRECTIONS[advHit.subHit - 7], player, attachmentItem.getAttachmentType(heldStack))) {
                                if (!player.m_150110_().f_35937_) {
                                    player.m_21008_(handIn, ItemHelper.consumeItem((ItemStack)heldStack, (int)1));
                                }
                            } else {
                                duct.openAttachmentGui(Constants.DIRECTIONS[advHit.subHit - 7], player);
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ModelUpdatePacket.sendToClient((Level)level, (BlockPos)pos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof IDuct) {
            IDuct host = (IDuct)tile;
            host.neighborChanged(blockIn, fromPos);
            IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)worldIn);
            if (gridContainer != null && gridContainer.onDuctNeighborChanged(host) || worldIn.m_7702_(fromPos) instanceof IDuct) {
                worldIn.m_186460_(pos, (Block)this, 1);
            }
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IGridContainer gridContainer;
        IDuct host;
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof IDuct && !(host = (IDuct)tile).hasGrid() && (gridContainer = IGridContainer.getCapability((LevelAccessor)worldIn)) != null) {
            gridContainer.onDuctPlaced(host, null);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof DuctBlockEntity) {
                DuctBlockEntity host = (DuctBlockEntity)tile;
                host.dropAttachments();
                IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)worldIn);
                if (gridContainer != null) {
                    gridContainer.onDuctRemoved(host);
                }
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60791_() > 0) {
            return state.m_60791_();
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof IGridHostLuminous) {
            IGridHostLuminous tile = (IGridHostLuminous)blockEntity;
            return tile.getLightValue();
        }
        return state.m_60791_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof DuctBlockEntity) {
            DuctBlockEntity duct = (DuctBlockEntity)tile;
            return DuctBlock.getConnectionShape(duct.getDuctModelData().getConnectionState());
        }
        return BASE_SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity tile;
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (worldIn.m_5776_() && (tile = worldIn.m_7702_(currentPos)) instanceof DuctBlockEntity) {
            tile.requestModelDataUpdate();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void dismantleBlock(Level world, BlockPos pos, BlockState state, HitResult target, Player player, boolean returnDrops) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof DuctBlockEntity) {
            DuctBlockEntity duct = (DuctBlockEntity)tile;
            duct.dismantleAttachments(player, returnDrops);
        }
        ItemStack dropBlock = this.getCloneItemStack(state, target, (BlockGetter)world, pos, player);
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!returnDrops || player == null || !player.m_36356_(dropBlock)) {
            Utils.dropDismantleStackIntoWorld((ItemStack)dropBlock, (Level)world, (BlockPos)pos);
        }
    }
}

