/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParagliderUtilsImpl {
    private ParagliderUtilsImpl() {
    }

    public static boolean canBreatheUnderwater(@NotNull Player player) {
        ItemStack feet;
        if (player.m_21023_(MobEffects.f_19608_)) {
            return true;
        }
        if (player.m_20096_() && (!player.canDrownInFluidType(player.getEyeInFluidType()) || player.m_9236_().m_8055_(new BlockPos((int)player.m_20185_(), (int)player.m_20188_(), (int)player.m_20189_())).m_60713_(Blocks.f_50628_))) {
            return true;
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (!head.m_41619_()) {
            if (head.m_41720_() == Items.f_42354_) {
                return true;
            }
            if (head.getEnchantmentLevel(Enchantments.f_44971_) > 0) {
                return true;
            }
        }
        return !(feet = player.m_6844_(EquipmentSlot.FEET)).m_41619_() && feet.getEnchantmentLevel(Enchantments.f_44973_) > 0;
    }

    public static boolean hasTag(@NotNull Block block, @NotNull TagKey<Block> tagKey) {
        ITagManager tagManager = ForgeRegistries.BLOCKS.tags();
        return tagManager != null && !tagManager.isKnownTagName(tagKey) && tagManager.getTag(tagKey).contains((Object)block);
    }

    @NotNull
    public static Item getItem(@NotNull ResourceLocation id) {
        return Objects.requireNonNullElse((Item)ForgeRegistries.ITEMS.getValue(id), Items.f_41852_);
    }

    @Nullable
    public static ResourceLocation getKey(@NotNull Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @NotNull
    public static Block getBlock(@NotNull ResourceLocation id) {
        return Objects.requireNonNullElse((Block)ForgeRegistries.BLOCKS.getValue(id), Blocks.f_50016_);
    }

    public static void forRemainingItem(@NotNull ItemStack stack, @NotNull @NotNull Consumer<@NotNull ItemStack> forRemainingItem) {
        if (stack.hasCraftingRemainingItem()) {
            forRemainingItem.accept(stack.getCraftingRemainingItem());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static InputConstants.Key getKey(@NotNull KeyMapping keyMapping) {
        return keyMapping.getKey();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isActiveAndMatches(@NotNull KeyMapping keyMapping, @NotNull InputConstants.Key key) {
        return keyMapping.isActiveAndMatches(key);
    }

    public static boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }
}

