/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.config.DebugCfg;

public abstract class StaminaWheelRenderer {
    private final Wheel wheel = new Wheel();
    private static final double[] renderPoints = new double[]{0.0, 0.125, 0.375, 0.625, 0.875, 1.0};

    public void renderStamina(@NotNull GuiGraphics graphics, double x, double y, double z) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        this.makeWheel((Player)player, this.wheel);
        this.render(graphics, this.wheel, x, y, z, this.isDebugEnabled((Player)player));
        this.wheel.reset();
    }

    protected boolean isDebugEnabled(@NotNull Player player) {
        return DebugCfg.get().debugPlayerMovement() && player.m_21206_().m_41720_() instanceof Paraglider;
    }

    protected abstract void makeWheel(@NotNull Player var1, @NotNull Wheel var2);

    protected void render(@NotNull GuiGraphics graphics, @NotNull Wheel wheel, double x, double y, double z, boolean debug) {
        RenderSystem.disableDepthTest();
        if (debug) {
            Font font = Minecraft.m_91087_().f_91062_;
            for (int i = 0; i < wheel.count; ++i) {
                String string = wheel.entries.get(i).toString();
                Objects.requireNonNull(font);
                graphics.m_280488_(font, string, 20, 10 + 9 * i, -1);
            }
        }
        StaminaWheelRenderer.draw(graphics, wheel, x, y, z, 10.0, debug);
    }

    private static void draw(@NotNull GuiGraphics graphics, @NotNull Wheel wheel, double x, double y, double z, double radius, boolean debug) {
        ArrayList<Vec2> debugVertices = debug ? new ArrayList<Vec2>() : null;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (WheelLevel wheelLevel : WheelLevel.values()) {
            for (int i = 0; i < wheel.count; ++i) {
                double currentStart;
                double end;
                double start;
                Wheel.Entry entry = wheel.entries.get(i);
                int alpha = FastColor.ARGB32.m_13655_((int)entry.color);
                if (alpha <= 0 || (start = wheelLevel.getProportion(entry.from)) >= 1.0 || (end = wheelLevel.getProportion(entry.to)) <= 0.0) continue;
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)entry.color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)entry.color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)entry.color) / 255.0f), (float)((float)alpha / 255.0f));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)wheelLevel.texture);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder b = tesselator.m_85915_();
                b.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
                b.m_5483_(x, y, z).m_7421_(0.5f, 0.5f).m_5752_();
                for (int j = 0; j < renderPoints.length - 1 && !((currentStart = renderPoints[j]) >= end); ++j) {
                    double currentEnd = renderPoints[j + 1];
                    if (currentEnd <= start) continue;
                    if (currentStart <= start) {
                        StaminaWheelRenderer.vert(b, x, y, z, start, radius, debugVertices);
                    }
                    if (currentEnd >= end) break;
                    StaminaWheelRenderer.vert(b, x, y, z, currentEnd, radius, debugVertices);
                }
                StaminaWheelRenderer.vert(b, x, y, z, end, radius, debugVertices);
                tesselator.m_85914_();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (debugVertices != null) {
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            stack.m_85837_(x, y, z);
            Font font = Minecraft.m_91087_().f_91062_;
            for (Vec2 vec : debugVertices) {
                float f;
                String s = vec.f_82470_ + " " + vec.f_82471_;
                int n = (int)(vec.f_82470_ > 0.0f ? vec.f_82470_ * (float)radius + 2.0f : vec.f_82470_ * (float)radius - 2.0f - (float)font.m_92895_(s));
                if (vec.f_82471_ > 0.0f) {
                    float f2 = vec.f_82471_ * (float)(-radius) - 2.0f;
                    Objects.requireNonNull(font);
                    f = f2 - 9.0f;
                } else {
                    f = vec.f_82471_ * (float)(-radius) + 2.0f;
                }
                graphics.m_280488_(font, s, n, (int)f, -16711936);
            }
            stack.m_85849_();
        }
    }

    private static void vert(BufferBuilder b, double x, double y, double z, double point, double radius, @Nullable List<Vec2> debugVertices) {
        double vy;
        double vx;
        if (point == 0.0 || point == 1.0) {
            vx = 0.0;
            vy = 1.0;
        } else if (point == 0.125) {
            vx = -1.0;
            vy = 1.0;
        } else if (point == 0.375) {
            vx = -1.0;
            vy = -1.0;
        } else if (point == 0.625) {
            vx = 1.0;
            vy = -1.0;
        } else if (point == 0.875) {
            vx = 1.0;
            vy = 1.0;
        } else if (point < 0.125 || point > 0.875) {
            vx = -Math.tan(point * (Math.PI * 2));
            vy = 1.0;
        } else if (point < 0.375) {
            vx = -1.0;
            vy = 1.0 / Math.tan(point * (Math.PI * 2));
        } else if (point < 0.625) {
            vx = Math.tan(point * (Math.PI * 2));
            vy = -1.0;
        } else {
            vx = 1.0;
            vy = -1.0 / Math.tan(point * (Math.PI * 2));
        }
        b.m_5483_(x + vx * radius, y + vy * -radius, z).m_7421_((float)(vx / 2.0 + 0.5), (float)(vy / 2.0 + 0.5)).m_5752_();
        if (debugVertices != null) {
            debugVertices.add(new Vec2((float)vx, (float)vy));
        }
    }

    public static final class Wheel {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int count;

        public void fill(int from, int to, int color) {
            if (from >= to) {
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                Entry e = this.entries.get(i);
                if (e.to <= from) continue;
                this.insert(e.from < from ? i + 1 : i, from, to, color);
                return;
            }
            this.insert(this.count, from, to, color);
        }

        private void insert(int index, int from, int to, int color) {
            int lastIndex = this.entries.size() - 1;
            Entry entry = lastIndex > this.count ? this.entries.remove(lastIndex) : new Entry();
            this.entries.add(index, entry);
            ++this.count;
            entry.from = from;
            entry.to = to;
            entry.color = color;
            for (int i = index + 1; i < this.count; ++i) {
                Entry e = this.entries.get(i);
                if (e.to > to) {
                    e.from = to;
                    return;
                }
                this.remove(i--);
            }
        }

        private void remove(int index) {
            this.entries.add(this.entries.remove(index));
            --this.count;
        }

        public void reset() {
            this.count = 0;
        }

        private static final class Entry {
            private int from;
            private int to;
            private int color;

            private Entry() {
            }

            public String toString() {
                return String.format("%d ~ %d: #%X", this.from, this.to, this.color);
            }
        }
    }

    public static enum WheelLevel {
        FIRST(ParagliderAPI.id("textures/stamina/first.png")),
        SECOND(ParagliderAPI.id("textures/stamina/second.png")),
        THIRD(ParagliderAPI.id("textures/stamina/third.png"));

        public final ResourceLocation texture;

        private WheelLevel(ResourceLocation texture) {
            this.texture = Objects.requireNonNull(texture);
        }

        public int start() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FIRST -> 0;
                case SECOND -> (int)((double)Cfg.get().maxStamina() / 3.0);
                case THIRD -> (int)((double)(Cfg.get().maxStamina() * 2) / 3.0);
            };
        }

        public int end() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FIRST -> (int)((double)Cfg.get().maxStamina() / 3.0);
                case SECOND -> (int)((double)(Cfg.get().maxStamina() * 2) / 3.0);
                case THIRD -> Cfg.get().maxStamina();
            };
        }

        public double getProportion(int value) {
            int start = this.start();
            if (start >= value) {
                return 0.0;
            }
            int end = this.end();
            if (end <= value) {
                return 1.0;
            }
            return (double)(value - start) / (double)(end - start);
        }
    }
}

