/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.gateways.client.GatewaysClient;
import dev.shadowsoffire.gateways.entity.EndlessGatewayEntity;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.EndlessGateway;
import dev.shadowsoffire.gateways.gate.endless.EndlessModifier;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EndlessGateClient {
    public static final ResourceLocation BARS = GatewaysClient.BARS;

    public static void appendPearlTooltip(EndlessGateway gate, Level level, List<Component> tooltips, TooltipFlag flag) {
        List<MutableComponent> list;
        List<Failure> failures;
        Wave wave = gate.baseWave();
        MutableComponent comp = Component.m_237115_((String)"tooltip.gateways.endless.base_wave").m_130940_(ChatFormatting.GRAY);
        tooltips.add((Component)comp);
        comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.entities").m_130948_(Style.f_131099_.m_178520_(8900331)));
        tooltips.add((Component)comp);
        for (WaveEntity waveEntity : wave.entities()) {
            comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).m_130948_(Style.f_131099_.m_178520_(8900331)));
            tooltips.add((Component)comp);
        }
        if (!wave.modifiers().isEmpty()) {
            comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.modifiers").m_130940_(ChatFormatting.RED));
            tooltips.add((Component)comp);
            for (WaveModifier waveModifier : wave.modifiers()) {
                waveModifier.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c.m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.RED))));
            }
        }
        comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.rewards").m_130940_(ChatFormatting.GOLD));
        tooltips.add((Component)comp);
        for (Reward reward : wave.rewards()) {
            reward.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).m_130940_(ChatFormatting.GOLD))));
        }
        int modifIdx = Math.floorMod(GatewaysClient.scrollIdx, gate.modifiers().size());
        EndlessModifier endlessModifier = gate.modifiers().get(modifIdx);
        if (Screen.m_96638_()) {
            Iterator<Object> value;
            comp = Component.m_237110_((String)"tooltip.gateways.endless.modifier", (Object[])new Object[]{modifIdx + 1, gate.modifiers().size()}).m_130940_(ChatFormatting.LIGHT_PURPLE);
            comp.m_7220_(CommonComponents.f_263701_);
            comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.scroll").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131162_(Boolean.valueOf(false))));
            tooltips.add((Component)comp);
            comp = AttributeHelper.list().m_7220_((Component)endlessModifier.appMode().getDescription().m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltips.add((Component)comp);
            if (endlessModifier.waveTime() != 0) {
                value = endlessModifier.waveTime() > 0 ? "+" + endlessModifier.waveTime() : String.valueOf(endlessModifier.waveTime());
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.endless.wave_time", (Object[])new Object[]{value}).m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltips.add((Component)comp);
            }
            if (endlessModifier.setupTime() != 0) {
                value = endlessModifier.setupTime() > 0 ? "+" + endlessModifier.setupTime() : String.valueOf(endlessModifier.setupTime());
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.endless.setup_time", (Object[])new Object[]{value}).m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltips.add((Component)comp);
            }
            if (!endlessModifier.entities().isEmpty()) {
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.entities").m_130948_(Style.f_131099_.m_178520_(8900331)));
                tooltips.add((Component)comp);
                for (WaveEntity waveEntity : endlessModifier.entities()) {
                    comp = AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).m_130948_(Style.f_131099_.m_178520_(8900331)));
                    tooltips.add((Component)comp);
                }
            }
            if (!endlessModifier.modifiers().isEmpty()) {
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.modifiers").m_130940_(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (WaveModifier waveModifier : endlessModifier.modifiers()) {
                    waveModifier.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c.m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.RED))));
                }
            }
            if (!endlessModifier.rewards().isEmpty()) {
                comp = AttributeHelper.list().m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.rewards").m_130940_(ChatFormatting.GOLD));
                tooltips.add((Component)comp);
                for (Reward reward : endlessModifier.rewards()) {
                    reward.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)Component.m_237110_((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).m_130940_(ChatFormatting.GOLD))));
                }
            }
        } else {
            comp = Component.m_237110_((String)("tooltip.gateways.endless.num_modif" + (gate.modifiers().size() == 1 ? "" : "s")), (Object[])new Object[]{gate.modifiers().size()}).m_130940_(ChatFormatting.LIGHT_PURPLE);
            comp.m_7220_(CommonComponents.f_263701_);
            comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.shift").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
            tooltips.add((Component)comp);
        }
        if (!(failures = gate.failures()).isEmpty()) {
            if (Screen.m_96637_()) {
                comp = Component.m_237115_((String)"tooltip.gateways.failures").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (Failure f : failures) {
                    f.appendHoverText(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)c.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)))));
                }
            } else {
                comp = Component.m_237110_((String)("tooltip.gateways.num_failure" + (failures.size() == 1 ? "" : "s")), (Object[])new Object[]{failures.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                comp.m_7220_(CommonComponents.f_263701_);
                comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.ctrl").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(list = gate.rules().buildDeviations()).isEmpty()) {
            if (Screen.m_96639_()) {
                comp = Component.m_237110_((String)"tooltip.gateways.rules", (Object[])new Object[]{list.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
                tooltips.add((Component)comp);
                list.forEach(c -> tooltips.add((Component)AttributeHelper.list().m_7220_((Component)c.m_130940_(ChatFormatting.DARK_GREEN))));
            } else {
                comp = Component.m_237110_((String)("tooltip.gateways.num_rule" + (list.size() == 1 ? "" : "s")), (Object[])new Object[]{list.size()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
                comp.m_7220_(CommonComponents.f_263701_);
                comp.m_7220_((Component)Component.m_237115_((String)"tooltip.gateways.alt").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
    }

    public static void renderBossBar(GatewayEntity gateEntity, Object guiGfx, int x, int y, boolean isInWorld) {
        EndlessGatewayEntity gate = (EndlessGatewayEntity)gateEntity;
        GuiGraphics gfx = (GuiGraphics)guiGfx;
        PoseStack pose = gfx.m_280168_();
        int color = gate.getGateway().color().m_131265_();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        int wave = gate.getWave() + 1;
        int enemies = gate.getActiveEnemies();
        int maxEnemies = gate.getMaxEnemies();
        int modifiers = gate.getModifiersApplied();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        int yBar1 = y + 6 + lineHeight;
        int yBar2 = yBar1 + 10 + lineHeight;
        int textY = y - lineHeight;
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, 0.01);
        gfx.m_280163_(BARS, x, yBar1, 0.0f, 60.0f, 182, 5, 256, 256);
        gfx.m_280163_(BARS, x, yBar2, 0.0f, 60.0f, 182, 5, 256, 256);
        pose.m_85849_();
        int barWidth = 183;
        float maxTime = gate.getMaxWaveTime();
        if (gate.isWaveActive()) {
            barWidth = (int)(183.0f * (float)enemies / (float)maxEnemies);
            if (barWidth > 0) {
                gfx.m_280163_(BARS, x, yBar1, 0.0f, 65.0f, barWidth, 5, 256, 256);
            }
            if ((barWidth = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f)) > 0) {
                gfx.m_280163_(BARS, x, yBar2, 0.0f, 65.0f, barWidth, 5, 256, 256);
            }
        } else {
            maxTime = gate.getSetupTime();
            barWidth = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
            if (barWidth > 0) {
                gfx.m_280163_(BARS, x, yBar1, 0.0f, 65.0f, barWidth, 5, 256, 256);
                gfx.m_280163_(BARS, x, yBar2, 0.0f, 65.0f, barWidth, 5, 256, 256);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent component = Component.m_237113_((String)gate.m_7770_().getString()).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
        int strWidth = font.m_92852_((FormattedText)component);
        int textX = x + 91 - strWidth / 2;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.m_280614_(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        int time = (int)maxTime - gate.getTicksActive();
        String str = I18n.m_118938_((String)"boss.gateways.endless.top", (Object[])new Object[]{wave, Character.valueOf('\u221e'), StringUtil.m_14404_((int)time)});
        String str2 = I18n.m_118938_((String)"boss.gateways.endless.bot", (Object[])new Object[]{enemies, maxEnemies, modifiers});
        if (!gate.isWaveActive()) {
            str = I18n.m_118938_((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtil.m_14404_((int)time)});
            str2 = I18n.m_118938_((String)"boss.gateways.endless.incoming", (Object[])new Object[]{maxEnemies});
        }
        component = Component.m_237113_((String)str).m_130940_(ChatFormatting.GREEN);
        strWidth = font.m_92852_((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        textY = yBar1 - lineHeight;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.m_280614_(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        component = Component.m_237113_((String)str2).m_130940_(ChatFormatting.GREEN);
        strWidth = font.m_92852_((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        textY = yBar2 - lineHeight;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.m_280614_(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
    }
}

