/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.IntPropertyData;
import mekanism.common.network.to_client.container.property.ItemStackPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SyncableItemStack
implements ISyncableData {
    private final Supplier<@NotNull ItemStack> getter;
    private final Consumer<@NotNull ItemStack> setter;
    @NotNull
    private ItemStack lastKnownValue = ItemStack.f_41583_;

    public static SyncableItemStack create(Supplier<@NotNull ItemStack> getter, Consumer<@NotNull ItemStack> setter) {
        return new SyncableItemStack(getter, setter);
    }

    private SyncableItemStack(Supplier<@NotNull ItemStack> getter, Consumer<@NotNull ItemStack> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @NotNull
    public ItemStack get() {
        return this.getter.get();
    }

    public void set(@NotNull ItemStack value) {
        this.setter.accept(value);
    }

    public void set(int amount) {
        ItemStack stack = this.get();
        if (!stack.m_41619_()) {
            stack.m_41764_(amount);
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        ItemStack value = this.get();
        if (value.m_41619_() && this.lastKnownValue.m_41619_()) {
            return ISyncableData.DirtyType.CLEAN;
        }
        boolean sameItem = ItemStack.m_150942_((ItemStack)value, (ItemStack)this.lastKnownValue);
        if (!sameItem || value.m_41613_() != this.lastKnownValue.m_41613_()) {
            this.lastKnownValue = value.m_41777_();
            return sameItem ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new IntPropertyData(property, this.get().m_41613_());
        }
        return new ItemStackPropertyData(property, this.get());
    }
}

