/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleDistortData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ParticleDistortData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleDistortData>(){

        public ParticleDistortData fromCommand(ParticleType<ParticleDistortData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = (float)reader.readDouble();
            return new ParticleDistortData(scale);
        }

        public ParticleDistortData fromNetwork(ParticleType<ParticleDistortData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleDistortData(buffer.readFloat());
        }
    };
    public static final Codec<ParticleDistortData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleDistortData::getScale)).apply((Applicative)builder, ParticleDistortData::new));
    private final float scale;

    public ParticleDistortData(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_DISTORT;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.scale));
    }
}

