/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser;

import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.BloodInfuserTickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class InfuseItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && tile.getTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        Optional<RecipeBloodInfuser> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe.isPresent() && this.addToProduceSlot(tile, recipe.get().getOutputItemFirst().m_41777_())) {
            tile.getInventory().m_7407_(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            tile.getTank().drain(this.getRequiredFluidAmount(tile, recipe), IFluidHandler.FluidAction.EXECUTE);
            tile.addXp(recipe.get().getXp());
        }
    }

    protected int getRequiredFluidAmount(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        if (!recipe.isPresent()) {
            return Integer.MAX_VALUE;
        }
        MutableInt amount = new MutableInt(recipe.get().getInputFluid().getAmount());
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, BlockEntityBloodInfuser.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeBloodInfuser> getRecipe(BlockEntityBloodInfuser tile) {
        return tile.getRecipe(this.getInfuseStack(tile));
    }

    @Override
    public int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        return recipe.map(RecipeBloodInfuser::getDuration).orElse(0);
    }

    private int getRequiredTicks(BlockEntityBloodInfuser tile, Optional<RecipeBloodInfuser> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntityBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    @Override
    public ItemStack willProduceItem(BlockEntityBloodInfuser tile) {
        return this.getRecipe(tile).map(recipe -> recipe.getOutputItemFirst().m_41777_()).orElse(ItemStack.f_41583_);
    }
}

