/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapper;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestalConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;

public class BlockEntitySanguinaryPedestal
extends BlockEntityTankInventory {
    private static final int MB_RATE = 100;
    public static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private final IFluidHandler bonusFluidHandler = new FluidHandlerWrapper((IFluidHandler)this.getTank()){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntitySanguinaryPedestal.this.hasEfficiency() && !resource.isEmpty()) {
                resource.setAmount((int)((double)resource.getAmount() * BlockSanguinaryPedestalConfig.efficiencyBoost));
            }
            return super.fill(resource, action);
        }
    };
    private RegionIterator regionIterator;

    public BlockEntitySanguinaryPedestal(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SANGUINARY_PEDESTAL, blockPos, blockState, 0, 1, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
    }

    public IFluidHandler getBonusFluidHandler() {
        return this.bonusFluidHandler;
    }

    @Override
    protected void addItemHandlerCapabilities() {
    }

    protected void afterBlockReplace(Level world, BlockPos location) {
        EvilCraft._instance.getPacketHandler().sendToAllAround((PacketBase)new SanguinaryPedestalBlockReplacePacket(location.m_123341_(), location.m_123342_(), location.m_123343_()), LocationHelpers.createTargetPointFromLocation((Level)world, (BlockPos)location, (int)15));
    }

    protected boolean hasEfficiency() {
        return ((BlockSanguinaryPedestal)this.m_58900_().m_60734_()).getTier() == 1;
    }

    private BlockPos getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(this.m_58899_(), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntitySanguinaryPedestal> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySanguinaryPedestal blockEntity) {
            int actions;
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            int n = actions = blockEntity.hasEfficiency() ? 5 : 1;
            while (!blockEntity.getTank().isFull() && actions > 0) {
                BlockPos location = blockEntity.getNextLocation();
                Block block = level.m_8055_(location).m_60734_();
                if (block instanceof BlockBloodStain) {
                    BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)location, (Capability)ForgeCapabilities.FLUID_HANDLER).ifPresent(source -> {
                        FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.getBonusFluidHandler(), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                        if (!moved.isEmpty()) {
                            blockEntity.afterBlockReplace(level, location);
                        }
                    });
                }
                --actions;
            }
            if (!blockEntity.getTank().isEmpty()) {
                for (Direction direction : Direction.values()) {
                    BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_(), (Capability)ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
                        FluidStack fluidStack;
                        if (!blockEntity.getTank().isEmpty() && handler.fill(fluidStack = new FluidStack(blockEntity.getTank().getFluid(), Math.min(100, blockEntity.getTank().getFluidAmount())), IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            blockEntity.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                }
            }
        }
    }
}

