/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.fluids;

import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.item.ModItems;

public class MurkyFluid
extends FluidType {
    public static ResourceLocation STILL = new ResourceLocation("mahoutsukai", "block/murky_still");
    public static ResourceLocation FLOW = new ResourceLocation("mahoutsukai", "block/murky_flow");
    public static Color COLOR = new Color(0, 60, 0, 230);
    private static final ForgeFlowingFluid.Properties PROPS = new ForgeFlowingFluid.Properties(ModFluids.MURKY_FLUID, ModFluids.MURKY_STILL, ModFluids.MURKY_FLOW).block(() -> (LiquidBlock)ModBlocks.murkyFluid.get()).bucket(() -> (Item)ModItems.murkyBucket.get());

    public MurkyFluid() {
        super(FluidType.Properties.create().viscosity(1000));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
            private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");

            public int getTintColor() {
                return -16759808;
            }

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return WATER_OVERLAY;
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return BiomeColors.m_108811_((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFF000000;
            }
        });
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        protected Source() {
            super(PROPS);
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        protected Flowing() {
            super(PROPS);
        }

        public int m_6718_(LevelReader world) {
            return 20;
        }
    }
}

