/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.jei.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.integration.jei.JeiDrawables;
import com.klikli_dev.theurgy.integration.jei.JeiRecipeTypes;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

public class IncubationCategory
implements IRecipeCategory<IncubationRecipe> {
    private final IDrawableAnimated animatedFire;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedAnimatedArrow;

    public IncubationCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(82, 60);
        this.animatedFire = JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_FIRE_FULL, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.INCUBATOR.get()));
        this.localizedName = Component.m_237115_((String)"theurgy.jei.category.incubation");
        this.cachedAnimatedArrow = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return JeiDrawables.asAnimatedDrawable(guiHelper, GuiTextures.JEI_ARROW_RIGHT_FULL, cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getAnimatedArrow(IncubationRecipe recipe) {
        int cookTime = recipe.getIncubationTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedAnimatedArrow.getUnchecked((Object)cookTime);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IncubationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiTextures.JEI_FIRE_EMPTY.render(guiGraphics, 28, 44);
        this.animatedFire.draw(guiGraphics, 28, 44);
        GuiTextures.JEI_ARROW_RIGHT_EMPTY.render(guiGraphics, 24, 22);
        this.getAnimatedArrow(recipe).draw(guiGraphics, 24, 22);
        this.drawCookTime(recipe, guiGraphics, 47);
    }

    protected void drawCookTime(IncubationRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.getIncubationTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IncubationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients(recipe.getMercury());
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List liquefactionRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.LIQUEFACTION.get()).stream().filter(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()) != null).collect(Collectors.toList());
        List<ItemStack> sulfurIngredients = Arrays.stream(recipe.getSulfur().m_43908_()).map(sulfur -> {
            if (sulfur.m_41782_()) {
                return sulfur;
            }
            Item sulfurItem = sulfur.m_41720_();
            Optional<ItemStack> sulfurWithNbt = liquefactionRecipes.stream().filter(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41720_() == sulfurItem).map(r -> r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())).findFirst();
            if (sulfurWithNbt.isPresent()) {
                sulfur = sulfur.m_41777_();
                sulfur.m_41751_(sulfurWithNbt.get().m_41783_());
            }
            return sulfur;
        }).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 21).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addItemStacks(sulfurIngredients);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 42).setBackground(JeiDrawables.INPUT_SLOT, -1, -1).addIngredients(recipe.getSalt());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 22).setBackground(JeiDrawables.OUTPUT_SLOT, -5, -5).addItemStacks(Arrays.asList(recipe.getResult().getStacks()));
    }

    public RecipeType<IncubationRecipe> getRecipeType() {
        return JeiRecipeTypes.INCUBATION;
    }
}

