/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
extends Ingredient {
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty());
    public static final Codec<FluidIngredient> CODEC = new PrimitiveCodec<FluidIngredient>(){

        public <T> DataResult<FluidIngredient> read(DynamicOps<T> ops, T input) {
            try {
                return DataResult.success((Object)((Object)FluidIngredient.fromJson((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input))));
            }
            catch (JsonParseException e) {
                return DataResult.error(() -> "Failed to parse Ingredient: " + e.getMessage());
            }
        }

        public <T> T write(DynamicOps<T> ops, FluidIngredient value) {
            return (T)JsonOps.INSTANCE.convertTo(ops, value.m_43942_());
        }
    };
    private final Value[] values;
    @Nullable
    private FluidStack[] fluidStacks;

    protected FluidIngredient(Stream<? extends Value> pValues) {
        super(Stream.empty());
        this.values = (Value[])pValues.toArray(Value[]::new);
    }

    public static FluidIngredient ofFluid() {
        return EMPTY;
    }

    public static FluidIngredient ofFluid(Fluid ... pFluids) {
        return FluidIngredient.ofFluid(Arrays.stream(pFluids).map(f -> new FluidStack(f, 1)));
    }

    public static FluidIngredient ofFluid(FluidStack ... pStacks) {
        return FluidIngredient.ofFluid(Arrays.stream(pStacks));
    }

    public static FluidIngredient ofFluid(Stream<FluidStack> pStacks) {
        return FluidIngredient.fromFluidValues(pStacks.filter(p_43944_ -> !p_43944_.isEmpty()).map(FluidValue::new));
    }

    public static FluidIngredient ofFluid(TagKey<Fluid> pTag) {
        return FluidIngredient.fromFluidValues(Stream.of(new TagValue(pTag)));
    }

    public static FluidIngredient fromFluidValues(Stream<? extends Value> pStream) {
        FluidIngredient ingredient = new FluidIngredient(pStream);
        return ingredient.m_43947_() ? EMPTY : ingredient;
    }

    public static FluidIngredient fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            if (pJson.isJsonObject()) {
                return FluidIngredient.fromFluidValues(Stream.of(FluidIngredient.fluidValueFromJson(pJson.getAsJsonObject())));
            }
            if (pJson.isJsonArray()) {
                JsonArray jsonarray = pJson.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one item must be defined");
                }
                return FluidIngredient.fromFluidValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_151264_ -> FluidIngredient.fluidValueFromJson(GsonHelper.m_13918_((JsonElement)p_151264_, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf pBuffer) {
        int size = pBuffer.m_130242_();
        if (size == -1) {
            return (FluidIngredient)CraftingHelper.getIngredient((ResourceLocation)pBuffer.m_130281_(), (FriendlyByteBuf)pBuffer);
        }
        return FluidIngredient.fromFluidValues(Stream.generate(() -> new FluidValue(pBuffer.readFluidStack())).limit(size));
    }

    public static Value fluidValueFromJson(JsonObject pJson) {
        if (pJson.has("fluid") && pJson.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (pJson.has("fluid")) {
            Fluid fluid = FluidIngredient.fluidFromJson(pJson);
            return new FluidValue(new FluidStack(fluid, 1));
        }
        if (pJson.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pJson, (String)"tag"));
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourcelocation);
            return new TagValue((TagKey<Fluid>)tagkey);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public static Fluid fluidFromJson(JsonObject pItemObject) {
        String s = GsonHelper.m_13906_((JsonObject)pItemObject, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(s));
        if (fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid: " + s);
        }
        return fluid;
    }

    protected void invalidate() {
        super.invalidate();
        this.fluidStacks = null;
    }

    public boolean m_43947_() {
        return this.values.length == 0;
    }

    public IntList m_43931_() {
        return super.m_43931_();
    }

    public ItemStack[] m_43908_() {
        return super.m_43908_();
    }

    public FluidStack[] getFluids() {
        if (this.fluidStacks == null) {
            this.fluidStacks = (FluidStack[])Arrays.stream(this.values).flatMap(value -> value.getFluids().stream()).distinct().toArray(FluidStack[]::new);
        }
        return this.fluidStacks;
    }

    public boolean test(@Nullable ItemStack pStack) {
        return false;
    }

    public JsonElement m_43942_() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        for (Value value : this.values) {
            jsonarray.add((JsonElement)value.serialize());
        }
        return jsonarray;
    }

    public boolean test(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (this.m_43947_()) {
            return fluidStack.isEmpty();
        }
        for (FluidStack fluid : this.getFluids()) {
            if (!fluidStack.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean testIgnoreNbt(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (this.m_43947_()) {
            return fluidStack.isEmpty();
        }
        for (FluidStack fluid : this.getFluids()) {
            if (fluidStack.getFluid() != fluid.getFluid()) continue;
            return true;
        }
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static interface Value {
        public Collection<FluidStack> getFluids();

        public JsonObject serialize();
    }

    public static class TagValue
    implements Value {
        private final TagKey<Fluid> tag;

        public TagValue(TagKey<Fluid> pTag) {
            this.tag = pTag;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            ArrayList<FluidStack> list = new ArrayList<FluidStack>();
            ForgeRegistries.FLUIDS.tags().getTag(this.tag).stream().forEach(fluid -> list.add(new FluidStack(fluid, 1)));
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonobject;
        }
    }

    public static class FluidValue
    implements Value {
        private final FluidStack fluid;

        public FluidValue(FluidStack fluid) {
            this.fluid = fluid;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            return ImmutableList.of((Object)this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid.getFluid()).toString());
            return jsonobject;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public FluidIngredient parse(FriendlyByteBuf buffer) {
            return FluidIngredient.fromFluidValues(Stream.generate(() -> new FluidValue(buffer.readFluidStack())).limit(buffer.m_130242_()));
        }

        public FluidIngredient parse(JsonObject json) {
            return FluidIngredient.fromFluidValues(Stream.of(FluidIngredient.fluidValueFromJson(json)));
        }

        public void write(FriendlyByteBuf buffer, FluidIngredient ingredient) {
            FluidStack[] fluids = ingredient.getFluids();
            buffer.m_130130_(fluids.length);
            for (FluidStack stack : fluids) {
                buffer.writeFluidStack(stack);
            }
        }
    }
}

