/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquefactionRecipe
implements Recipe<RecipeWrapperWithFluid> {
    public static final int DEFAULT_LIQUEFACTION_TIME = 100;
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final FluidIngredient solvent;
    protected final int solventAmount;
    protected final ItemStack result;
    protected final int liquefactionTime;

    public LiquefactionRecipe(ResourceLocation pId, Ingredient pIngredient, FluidIngredient pSolvent, int solventAmount, ItemStack pResult, int liquefactionTime) {
        this.id = pId;
        this.ingredient = pIngredient;
        this.solvent = pSolvent;
        this.solventAmount = solventAmount;
        this.result = pResult;
        this.liquefactionTime = liquefactionTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.LIQUEFACTION.get();
    }

    public boolean matches(RecipeWrapperWithFluid pContainer, Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        return this.ingredient.test(pContainer.m_8020_(0)) && this.solvent.test(fluid) && fluid.getAmount() >= this.solventAmount;
    }

    public ItemStack assemble(RecipeWrapperWithFluid pInv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BlockRegistry.LIQUEFACTION_CAULDRON.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.LIQUEFACTION.get();
    }

    public int getLiquefactionTime() {
        return this.liquefactionTime;
    }

    public FluidIngredient getSolvent() {
        return this.solvent;
    }

    public int getSolventAmount() {
        return this.solventAmount;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static class Serializer
    implements RecipeSerializer<LiquefactionRecipe> {
        public LiquefactionRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            JsonArray ingredientElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientElement);
            JsonArray solventElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"solvent") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"solvent") : GsonHelper.m_13930_((JsonObject)pJson, (String)"solvent");
            FluidIngredient solvent = FluidIngredient.fromJson((JsonElement)solventElement);
            int solventAmount = GsonHelper.m_13927_((JsonObject)pJson, (String)"solvent_amount");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"), (boolean)true, (boolean)true);
            int liquefactionTime = GsonHelper.m_13824_((JsonObject)pJson, (String)"liquefaction_time", (int)100);
            result = this.fixSourceIdIfNecessary(result, ingredient);
            return new LiquefactionRecipe(pRecipeId, ingredient, solvent, solventAmount, result, liquefactionTime);
        }

        public ItemStack fixSourceIdIfNecessary(ItemStack resultItem, Ingredient ingredient) {
            Item item = resultItem.m_41720_();
            if (item instanceof AlchemicalSulfurItem) {
                AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
                if (sulfur.autoGenerateSourceIdInRecipe && AlchemicalSulfurItem.getSourceStack(resultItem).m_41619_()) {
                    ItemStack modified = resultItem.m_41777_();
                    if (ingredient.f_43902_.length > 0) {
                        Ingredient.Value value = ingredient.f_43902_[0];
                        if (value instanceof Ingredient.TagValue) {
                            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                            modified.m_41784_().m_128359_("theurgy:sulfur.source.id", "#" + String.valueOf(tagValue.f_43959_.f_203868_()));
                            return modified;
                        }
                        value = ingredient.f_43902_[0];
                        if (value instanceof Ingredient.ItemValue) {
                            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                            modified.m_41784_().m_128359_("theurgy:sulfur.source.id", ForgeRegistries.ITEMS.getKey((Object)((ItemStack)itemValue.m_6223_().stream().findFirst().get()).m_41720_()).toString());
                            return modified;
                        }
                    }
                    throw new IllegalArgumentException("AlchemicalSulfurItem " + String.valueOf(resultItem) + " is configured to generate source id in recipe, but Ingredient.values[0] is not a tag or item value so we don't know how to get the source.");
                }
            }
            return resultItem;
        }

        public LiquefactionRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            FluidIngredient solvent = FluidIngredient.fromNetwork(pBuffer);
            int solventAmount = pBuffer.m_130242_();
            ItemStack result = pBuffer.m_130267_();
            int liquefactionTime = pBuffer.m_130242_();
            return new LiquefactionRecipe(pRecipeId, ingredient, solvent, solventAmount, result, liquefactionTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, LiquefactionRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pRecipe.solvent.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.solventAmount);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130130_(pRecipe.liquefactionTime);
        }
    }
}

