/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.recipe.result.RecipeResult;
import com.klikli_dev.theurgy.content.recipe.wrapper.IncubatorRecipeWrapper;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IncubationRecipe
implements Recipe<IncubatorRecipeWrapper> {
    public static final int DEFAULT_INCUBATION_TIME = 100;
    protected final ResourceLocation id;
    protected final Ingredient mercury;
    protected final Ingredient salt;
    protected final Ingredient sulfur;
    protected final RecipeResult result;
    protected final int incubationTime;

    public IncubationRecipe(ResourceLocation pId, Ingredient mercury, Ingredient salt, Ingredient sulfur, RecipeResult pResult, int incubationTime) {
        this.id = pId;
        this.mercury = mercury;
        this.salt = salt;
        this.sulfur = sulfur;
        this.result = pResult;
        this.incubationTime = incubationTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.INCUBATION.get();
    }

    public boolean matches(IncubatorRecipeWrapper pContainer, Level pLevel) {
        return this.mercury.test(pContainer.getMercuryVesselInv().getStackInSlot(0)) && this.salt.test(pContainer.getSaltVesselInv().getStackInSlot(0)) && this.sulfur.test(pContainer.getSulfurVesselInv().getStackInSlot(0));
    }

    public ItemStack assemble(IncubatorRecipeWrapper pInv, RegistryAccess registryAccess) {
        return this.result.getStack().m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.getStack();
    }

    public RecipeResult getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.mercury);
        nonnulllist.add((Object)this.salt);
        nonnulllist.add((Object)this.sulfur);
        return nonnulllist;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BlockRegistry.INCUBATOR.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.INCUBATION.get();
    }

    public int getIncubationTime() {
        return this.incubationTime;
    }

    public Ingredient getMercury() {
        return this.mercury;
    }

    public Ingredient getSalt() {
        return this.salt;
    }

    public Ingredient getSulfur() {
        return this.sulfur;
    }

    public static class Serializer
    implements RecipeSerializer<IncubationRecipe> {
        public IncubationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            JsonArray mercuryElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"mercury") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"mercury") : GsonHelper.m_13930_((JsonObject)pJson, (String)"mercury");
            Ingredient mercury = Ingredient.m_43917_((JsonElement)mercuryElement);
            JsonArray saltElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"salt") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"salt") : GsonHelper.m_13930_((JsonObject)pJson, (String)"salt");
            Ingredient salt = Ingredient.m_43917_((JsonElement)saltElement);
            JsonArray sulfurElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"sulfur") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"sulfur") : GsonHelper.m_13930_((JsonObject)pJson, (String)"sulfur");
            Ingredient sulfur = Ingredient.m_43917_((JsonElement)sulfurElement);
            RecipeResult result = RecipeResult.fromJson(GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            int incubationTime = GsonHelper.m_13824_((JsonObject)pJson, (String)"incubation_time", (int)100);
            return new IncubationRecipe(pRecipeId, mercury, salt, sulfur, result, incubationTime);
        }

        public IncubationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient mercury = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient salt = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient sulfur = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            RecipeResult result = RecipeResult.fromNetwork(pBuffer);
            int incubationTime = pBuffer.m_130242_();
            return new IncubationRecipe(pRecipeId, mercury, salt, sulfur, result, incubationTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, IncubationRecipe pRecipe) {
            pRecipe.mercury.m_43923_(pBuffer);
            pRecipe.salt.m_43923_(pBuffer);
            pRecipe.sulfur.m_43923_(pBuffer);
            pRecipe.result.toNetwork(pBuffer);
            pBuffer.m_130130_(pRecipe.incubationTime);
        }
    }
}

