/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item;

import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSetDivinationResult;
import com.klikli_dev.theurgy.registry.BlockTagRegistry;
import com.klikli_dev.theurgy.registry.SoundRegistry;
import com.klikli_dev.theurgy.scanner.ScanManager;
import com.klikli_dev.theurgy.util.EntityUtil;
import com.klikli_dev.theurgy.util.LevelUtil;
import com.klikli_dev.theurgy.util.TagUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;

public class DivinationRodItem
extends Item {
    public static final float NOT_FOUND = 7.0f;
    public static final float SEARCHING = 8.0f;
    public Tier defaultTier;
    public TagKey<Block> defaultAllowedBlocksTag;
    public TagKey<Block> defaultDisallowedBlocksTag;
    public int defaultRange;
    public int defaultDuration;
    public int defaultDurability;
    public boolean defaultAllowAttuning;

    public DivinationRodItem(Item.Properties pProperties, Tier defaultTier, TagKey<Block> defaultAllowedBlocksTag, TagKey<Block> defaultDisallowedBlocksTag, int defaultRange, int defaultDuration, int defaultDurability, boolean defaultAllowAttuning) {
        super(pProperties);
        this.defaultTier = defaultTier;
        this.defaultAllowedBlocksTag = defaultAllowedBlocksTag;
        this.defaultDisallowedBlocksTag = defaultDisallowedBlocksTag;
        this.defaultRange = defaultRange;
        this.defaultDuration = defaultDuration;
        this.defaultDurability = defaultDurability;
        this.defaultAllowAttuning = defaultAllowAttuning;
    }

    public static String getLinkedBlockId(ItemStack divinationRod) {
        return divinationRod.m_41784_().m_128461_("theurgy:divination.linked_block_id");
    }

    public static boolean hasLinkedBlock(ItemStack divinationRod) {
        return divinationRod.m_41782_() && divinationRod.m_41783_().m_128441_("theurgy:divination.linked_block_id");
    }

    public static ItemStack getLinkedBlockStack(ItemStack divinationRod) {
        if (DivinationRodItem.hasLinkedBlock(divinationRod)) {
            ItemStack targetStack;
            String targetId = DivinationRodItem.getLinkedBlockId(divinationRod);
            if (targetId.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(targetId.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                targetStack = TagUtil.getItemStackForTag((TagKey<Item>)tag);
            } else {
                ResourceLocation itemId = new ResourceLocation(targetId);
                targetStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId));
            }
            return targetStack;
        }
        return ItemStack.f_41583_;
    }

    private static void scanLinkedBlock(Player player, String id, int range, int duration) {
        ResourceLocation targetId = new ResourceLocation(id);
        Set<Block> blocks = DivinationRodItem.getScanTargetsForId(targetId);
        ScanManager.get().beginScan(player, blocks, range, duration);
    }

    private static void scanLinkedTag(Player player, String id, int range, int duration) {
        ResourceLocation targetId = new ResourceLocation(id.substring(1));
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)targetId);
        Set<Block> blocks = ForgeRegistries.BLOCKS.tags().getTag(tagKey).stream().collect(Collectors.toSet());
        if (!blocks.isEmpty()) {
            ScanManager.get().beginScan(player, blocks, range, duration);
        }
    }

    public static Set<Block> getScanTargetsForId(ResourceLocation linkedBlockId) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)DivinationRodItem.getOreTagFromBlockId(linkedBlockId));
        ITag tag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
        if (!tag.isEmpty()) {
            return tag.stream().collect(Collectors.toSet());
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(linkedBlockId);
        if (block != null) {
            Block deepslateBlock = null;
            if (linkedBlockId.m_135815_().contains("_ore") && !linkedBlockId.m_135815_().contains("deepslate_")) {
                ResourceLocation deepslateId = new ResourceLocation(linkedBlockId.m_135827_(), "deepslate_" + linkedBlockId.m_135815_());
                deepslateBlock = (Block)ForgeRegistries.BLOCKS.getValue(deepslateId);
            }
            return deepslateBlock != null && deepslateBlock != Blocks.f_50016_ ? Set.of(block, deepslateBlock) : Set.of(block);
        }
        return Set.of();
    }

    public static ResourceLocation getOreTagFromBlockId(ResourceLocation blockId) {
        String path = blockId.m_135815_();
        String oreName = path.replace("_ore", "").replace("ore_", "").replace("_deepslate", "").replace("deepslate_", "");
        return new ResourceLocation("forge:ores/" + oreName);
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.m_41784_().m_128451_("theurgy:divination.setting.max_damage");
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ScanManager.get().updateScan(player, false);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Tier tier = this.getMiningTier(stack);
        TagKey<Block> allowedBlocksTag = this.getAllowedBlocksTag(stack);
        TagKey<Block> disallowedBlocksTag = this.getDisallowedBlocksTag(stack);
        if (player.m_6144_()) {
            if (!stack.m_41784_().m_128471_("theurgy:divination.setting.allow_attuning")) {
                if (!level.f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.theurgy.divination_rod.attuning_not_allowed"));
                }
                return InteractionResult.FAIL;
            }
            BlockState state = level.m_8055_(pos);
            if (!state.m_60795_()) {
                if (!TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state)) {
                    if (!level.f_46443_) {
                        player.m_213846_((Component)Component.m_237110_((String)"message.theurgy.divination_rod.tier_too_low", (Object[])new Object[]{this.getBlockDisplayComponent(state.m_60734_())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (!state.m_204336_(allowedBlocksTag)) {
                    if (!level.f_46443_) {
                        player.m_213846_((Component)Component.m_237110_((String)"message.theurgy.divination_rod.block_not_allowed", (Object[])new Object[]{this.getBlockDisplayComponent(state.m_60734_())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (state.m_204336_(disallowedBlocksTag)) {
                    if (!level.f_46443_) {
                        player.m_213846_((Component)Component.m_237110_((String)"message.theurgy.divination_rod.block_disallowed", (Object[])new Object[]{this.getBlockDisplayComponent(state.m_60734_())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.f_46443_) {
                    stack.m_41784_().m_128359_("theurgy:divination.linked_block_id", ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
                    player.m_213846_((Component)Component.m_237110_((String)"message.theurgy.divination_rod.linked", (Object[])new Object[]{this.getBlockDisplayComponent(state.m_60734_())}));
                }
                level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (DivinationRodItem.hasLinkedBlock(stack)) {
                CompoundTag tag = stack.m_41783_();
                tag.m_128350_("theurgy:divination.distance", 8.0f);
                player.m_6672_(hand);
                level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundRegistry.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (level.f_46443_) {
                    String targetId = DivinationRodItem.getLinkedBlockId(stack);
                    if (targetId.startsWith("#")) {
                        DivinationRodItem.scanLinkedTag(player, targetId, tag.m_128451_("theurgy:divination.setting.range"), tag.m_128451_("theurgy:divination.setting.duration"));
                    } else {
                        DivinationRodItem.scanLinkedBlock(player, targetId, tag.m_128451_("theurgy:divination.setting.range"), tag.m_128451_("theurgy:divination.setting.duration"));
                    }
                }
            } else if (!level.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"message.theurgy.divination_rod.no_link"));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        if (stack.m_41773_() >= stack.m_41776_()) {
            player.m_21190_(player.m_7655_());
            Item item = stack.m_41720_();
            stack.m_41774_(1);
            player.m_36246_(Stats.f_12983_.m_12902_((Object)item));
            stack.m_41721_(0);
            return stack;
        }
        player.m_36335_().m_41524_((Item)this, stack.m_41784_().m_128451_("theurgy:divination.setting.duration"));
        stack.m_41784_().m_128350_("theurgy:divination.distance", 7.0f);
        if (level.f_46443_) {
            BlockPos result = ScanManager.get().finishScan(player);
            float distance = this.getDistance(player.m_20182_(), result);
            stack.m_41783_().m_128350_("theurgy:divination.distance", distance);
            Networking.sendToServer(new MessageSetDivinationResult(result, distance));
            if (result != null) {
                stack.m_41783_().m_128356_("theurgy:divination.pos", result.m_121878_());
                this.spawnResultParticle(result, level, (LivingEntity)player);
            }
        } else if (!player.m_150110_().f_35937_) {
            stack.m_220157_(1, player.m_217043_(), null);
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return stack.m_41784_().m_128451_("theurgy:divination.setting.duration");
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity pLivingEntity, int pTimeCharged) {
        BlockPos result;
        if (!stack.m_41784_().m_128441_("theurgy:divination.pos")) {
            stack.m_41784_().m_128350_("theurgy:divination.distance", 7.0f);
        } else {
            result = BlockPos.m_122022_((long)stack.m_41783_().m_128454_("theurgy:divination.pos"));
            float distance = this.getDistance(pLivingEntity.m_20182_(), result);
            stack.m_41783_().m_128350_("theurgy:divination.distance", distance);
        }
        if (level.f_46443_) {
            ScanManager.get().cancelScan();
            if (stack.m_41783_().m_128441_("theurgy:divination.pos")) {
                result = BlockPos.m_122022_((long)stack.m_41783_().m_128454_("theurgy:divination.pos"));
                this.spawnResultParticle(result, level, pLivingEntity);
            }
        }
        super.m_5551_(stack, level, pLivingEntity, pTimeCharged);
    }

    public Component m_7626_(ItemStack pStack) {
        if (DivinationRodItem.hasLinkedBlock(pStack)) {
            ItemStack stack = DivinationRodItem.getLinkedBlockStack(pStack);
            if (!stack.m_41619_()) {
                MutableComponent blockComponent = ComponentUtils.m_130748_((Component)Component.m_237119_().m_7220_(stack.m_41786_()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)))).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack))));
                return Component.m_237110_((String)(this.m_5524_() + ".linked"), (Object[])new Object[]{blockComponent});
            }
            MutableComponent blockComponent = ComponentUtils.m_130748_((Component)Component.m_237115_((String)"item.theurgy.divination_rod.unknown_linked_block").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(true)))).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack))));
            return Component.m_237110_((String)(this.m_5524_() + ".linked"), (Object[])new Object[]{blockComponent});
        }
        return super.m_7626_(pStack);
    }

    public void m_142312_(CompoundTag tag) {
        if (!tag.m_128441_("theurgy:divination.setting.tier")) {
            tag.m_128359_("theurgy:divination.setting.tier", TierSortingRegistry.getName((Tier)this.defaultTier).toString());
        }
        if (!tag.m_128441_("theurgy:divination.setting.allowed_blocks_tag")) {
            tag.m_128359_("theurgy:divination.setting.allowed_blocks_tag", this.defaultAllowedBlocksTag.f_203868_().toString());
        }
        if (!tag.m_128441_("theurgy:divination.setting.disallowed_blocks_tag")) {
            tag.m_128359_("theurgy:divination.setting.disallowed_blocks_tag", this.defaultDisallowedBlocksTag.f_203868_().toString());
        }
        if (!tag.m_128441_("theurgy:divination.setting.range")) {
            tag.m_128405_("theurgy:divination.setting.range", this.defaultRange);
        }
        if (!tag.m_128441_("theurgy:divination.setting.duration")) {
            tag.m_128405_("theurgy:divination.setting.duration", this.defaultDuration);
        }
        if (!tag.m_128441_("theurgy:divination.setting.max_damage")) {
            tag.m_128405_("theurgy:divination.setting.max_damage", this.defaultDurability);
        }
        if (!tag.m_128441_("theurgy:divination.setting.allow_attuning")) {
            tag.m_128379_("theurgy:divination.setting.allow_attuning", this.defaultAllowAttuning);
        }
        super.m_142312_(tag);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (DivinationRodItem.hasLinkedBlock(pStack)) {
            ItemStack stack = DivinationRodItem.getLinkedBlockStack(pStack);
            if (!stack.m_41619_()) {
                MutableComponent blockComponent = Component.m_237119_().m_7220_(stack.m_41786_()).m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack))));
                this.getBlockDisplayComponent(stack);
                pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.theurgy..divination_rod.linked_to", (Object[])new Object[]{blockComponent}).m_130940_(ChatFormatting.GRAY));
                if (pStack.m_41783_().m_128441_("theurgy:divination.pos")) {
                    BlockPos pos = BlockPos.m_122022_((long)pStack.m_41783_().m_128454_("theurgy:divination.pos"));
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.theurgy..divination_rod.last_result", (Object[])new Object[]{blockComponent, ComponentUtils.m_130748_((Component)Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.GREEN))}).m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.theurgy..divination_rod.no_link"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public float getDistance(Vec3 playerPosition, BlockPos result) {
        if (result == null) {
            return 7.0f;
        }
        Vec3 resultCenter = Vec3.m_82512_((Vec3i)result);
        Vec3 playerPosition2d = new Vec3(playerPosition.f_82479_, 0.0, playerPosition.f_82481_);
        Vec3 resultCenter2d = new Vec3(resultCenter.f_82479_, 0.0, resultCenter.f_82481_);
        double distance = playerPosition2d.m_82554_(resultCenter2d);
        if (distance < 6.0) {
            return 0.0f;
        }
        if (distance < 15.0) {
            return 1.0f;
        }
        if (distance < 25.0) {
            return 2.0f;
        }
        if (distance < 35.0) {
            return 3.0f;
        }
        if (distance < 45.0) {
            return 4.0f;
        }
        if (distance < 65.0) {
            return 5.0f;
        }
        return 6.0f;
    }

    protected MutableComponent getBlockDisplayComponent(Block block) {
        return this.getBlockDisplayComponent(new ItemStack((ItemLike)block));
    }

    protected MutableComponent getBlockDisplayComponent(ItemStack stack) {
        Component displayName = stack.m_41786_();
        return ComponentUtils.m_130748_((Component)displayName).m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack))));
    }

    protected void spawnResultParticle(BlockPos result, Level level, LivingEntity entity) {
        Vec3 to;
        float visualizationRange = 10.0f;
        Vec3 from = new Vec3(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_());
        Vec3 resultVec = Vec3.m_82512_((Vec3i)result);
        Vec3 dist = resultVec.m_82546_(from);
        Vec3 dir = dist.m_82541_();
        Vec3 vec3 = to = dist.m_82553_() <= 10.0 ? resultVec : from.m_82549_(dir.m_82490_(10.0));
        if (level.m_46749_(BlockPos.m_274446_((Position)to)) && level.m_46749_(BlockPos.m_274446_((Position)from)) && level.f_46443_) {
            FollowProjectile aoeProjectile = new FollowProjectile(level, from, to, 255, 25, 180, 0.25f);
            EntityUtil.spawnEntityClientSide(level, (Entity)aoeProjectile, true);
        }
    }

    public Tier getMiningTier(ItemStack stack) {
        String tier = stack.m_41784_().m_128461_("theurgy:divination.setting.tier");
        return TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(tier));
    }

    public TagKey<Block> getAllowedBlocksTag(ItemStack stack) {
        String allowedBlocksTag = stack.m_41784_().m_128461_("theurgy:divination.setting.allowed_blocks_tag");
        return BlockTagRegistry.tag(new ResourceLocation(allowedBlocksTag));
    }

    public TagKey<Block> getDisallowedBlocksTag(ItemStack stack) {
        String disallowedBlocksTag = stack.m_41784_().m_128461_("theurgy:divination.setting.disallowed_blocks_tag");
        return BlockTagRegistry.tag(new ResourceLocation(disallowedBlocksTag));
    }

    public static void registerCreativeModeTabs(DivinationRodItem item, CreativeModeTab.Output output) {
        Level level = LevelUtil.getLevelWithoutContext();
        if (level != null) {
            RecipeManager recipeManager = level.m_7465_();
            recipeManager.m_44051_().forEach(recipe -> {
                if (recipe.m_8043_(level.m_9598_()) != null && recipe.m_8043_(level.m_9598_()).m_41720_() == item) {
                    output.m_246342_(recipe.m_8043_(level.m_9598_()).m_41777_());
                }
            });
        }
    }

    public static class DistHelper {
        public static ItemPropertyFunction DIVINATION_DISTANCE = (stack, world, entity, i) -> {
            if (!stack.m_41784_().m_128441_("theurgy:divination.distance") || stack.m_41783_().m_128457_("theurgy:divination.distance") < 0.0f) {
                return 7.0f;
            }
            return stack.m_41783_().m_128457_("theurgy:divination.distance");
        };
    }
}

