/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.distiller;

import com.klikli_dev.theurgy.content.apparatus.distiller.DistillationCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistillationStorageBehaviour
extends StorageBehaviour<DistillationStorageBehaviour> {
    public ItemStackHandler inputInventory;
    public ItemStackHandler outputInventory;
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper;
    public CombinedInvWrapper inventory;
    public LazyOptional<IItemHandler> inventoryCapability;
    public LazyOptional<IItemHandler> inputInventoryCapability;
    public LazyOptional<IItemHandler> outputInventoryCapability;
    public Supplier<DistillationCraftingBehaviour> craftingBehaviour;

    public DistillationStorageBehaviour(BlockEntity blockEntity, Supplier<DistillationCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.outputInventory = new OutputInventory();
        this.outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryTakeOnlyWrapper});
        this.inventoryCapability = LazyOptional.of(() -> this.inventory);
        this.inputInventoryCapability = LazyOptional.of(() -> this.inputInventory);
        this.outputInventoryCapability = LazyOptional.of(() -> this.outputInventoryTakeOnlyWrapper);
        this.register(this.inventoryCapability);
        this.register(this.inputInventoryCapability);
        this.register(this.outputInventoryCapability);
    }

    @Override
    public void readNetwork(CompoundTag pTag) {
        if (pTag.m_128441_("inputInventory")) {
            this.inputInventory.deserializeNBT(pTag.m_128469_("inputInventory"));
        }
        if (pTag.m_128441_("outputInventory")) {
            this.outputInventory.deserializeNBT(pTag.m_128469_("outputInventory"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag) {
        pTag.m_128365_("inputInventory", (Tag)this.inputInventory.serializeNBT());
        pTag.m_128365_("outputInventory", (Tag)this.outputInventory.serializeNBT());
    }

    @Override
    public void saveAdditional(CompoundTag pTag) {
        this.writeNetwork(pTag);
    }

    @Override
    public void load(CompoundTag pTag) {
        this.readNetwork(pTag);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.inputInventoryCapability.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputInventoryCapability.cast();
            }
            return this.inventoryCapability.cast();
        }
        return LazyOptional.empty();
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            DistillationStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            DistillationStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return DistillationStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            DistillationStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            DistillationStorageBehaviour.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            DistillationStorageBehaviour.this.setChanged();
        }
    }
}

