/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.datagen.recipe.IngredientWithCount;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DigestionCraftingBehaviour
extends CraftingBehaviour<RecipeWrapperWithFluid, DigestionRecipe, DigestionCachedCheck> {
    protected Supplier<IFluidHandler> fluidTankSupplier;

    public DigestionCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> fluidTankSupplier) {
        super(blockEntity, Lazy.of(() -> new RecipeWrapperWithFluid((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)fluidTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new DigestionCachedCheck((RecipeType<DigestionRecipe>)((RecipeType)RecipeTypeRegistry.DIGESTION.get())));
        this.fluidTankSupplier = fluidTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return ((DigestionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    public boolean canProcess(FluidStack stack) {
        if (this.fluidTankSupplier.get().getFluidInTank(0).isFluidEqual(stack)) {
            return true;
        }
        return ((DigestionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    protected int getIngredientCount(DigestionRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(DigestionRecipe recipe) {
        return recipe.getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 200;
    }

    @Override
    protected boolean craft(DigestionRecipe pRecipe) {
        ItemStack assembledStack = pRecipe.assemble((RecipeWrapperWithFluid)((Object)this.recipeWrapperSupplier.get()), this.blockEntity.m_58904_().m_9598_());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        block0: for (IngredientWithCount ingredient : pRecipe.getIngredientsWithCount()) {
            for (int i = 0; i < ((IItemHandlerModifiable)this.inputInventorySupplier.get()).getSlots(); ++i) {
                if (!ingredient.ingredient().test(((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(i))) continue;
                ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(i, ingredient.count(), false);
                continue block0;
            }
        }
        this.fluidTankSupplier.get().drain(pRecipe.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

