/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsutility.playerprops.PacketSendBuffsToClient;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BuffProperties {
    public static final int BUFF_MAXTICKS = 180;
    private int buffTimeout = 0;
    private final Map<PlayerBuff, Integer> buffs = new HashMap<PlayerBuff, Integer>();
    private boolean oldAllowFlying = false;
    private boolean allowFlying = false;
    private boolean globalSyncNeeded = true;
    private boolean onElevator = false;

    private void syncBuffs(ServerPlayer player) {
        RFToolsUtilityMessages.sendToPlayer(PacketSendBuffsToClient.create(this.buffs), (Player)player);
    }

    public void tickBuffs(ServerPlayer player) {
        --this.buffTimeout;
        if (this.buffTimeout <= 0) {
            this.buffTimeout = 180;
            HashMap<PlayerBuff, Integer> copyBuffs = new HashMap<PlayerBuff, Integer>(this.buffs);
            this.buffs.clear();
            boolean syncNeeded = false;
            for (Map.Entry entry : copyBuffs.entrySet()) {
                int timeout = (Integer)entry.getValue();
                if ((timeout -= 180) > 0) {
                    this.buffs.put((PlayerBuff)((Object)entry.getKey()), timeout);
                    continue;
                }
                syncNeeded = true;
            }
            if (syncNeeded) {
                this.syncBuffs(player);
                this.performBuffs(player);
                this.globalSyncNeeded = false;
            }
        }
        if (this.globalSyncNeeded) {
            this.globalSyncNeeded = false;
            this.syncBuffs(player);
            this.performBuffs(player);
        }
    }

    private void performBuffs(ServerPlayer player) {
        boolean enableFlight = false;
        if (this.onElevator) {
            enableFlight = true;
            player.m_150110_().f_35935_ = true;
        } else {
            for (PlayerBuff buff : this.buffs.keySet()) {
                if (buff != PlayerBuff.BUFF_FLIGHT) continue;
                enableFlight = true;
                break;
            }
        }
        boolean oldAllow = player.m_150110_().f_35936_;
        if (enableFlight) {
            if (!this.allowFlying) {
                this.oldAllowFlying = player.m_150110_().f_35936_;
                this.allowFlying = true;
            }
            player.m_150110_().f_35936_ = true;
        } else if (this.allowFlying) {
            player.m_150110_().f_35936_ = this.oldAllowFlying;
            if (player.m_150110_().f_35937_) {
                player.m_150110_().f_35936_ = true;
            }
            this.allowFlying = false;
        }
        if (player.m_150110_().f_35936_ != oldAllow && !player.m_150110_().f_35936_) {
            player.m_150110_().f_35935_ = false;
        }
        player.m_6885_();
    }

    public static void enableElevatorMode(Player player) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {
            h.onElevator = true;
            h.performBuffs((ServerPlayer)player);
        });
    }

    public static void disableElevatorMode(Player player) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {
            h.onElevator = false;
            player.m_150110_().f_35935_ = false;
            h.performBuffs((ServerPlayer)player);
        });
    }

    public static void addBuffToPlayer(Player player, PlayerBuff buff, int ticks) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> h.addBuff((ServerPlayer)player, buff, ticks));
    }

    public void addBuff(ServerPlayer player, PlayerBuff buff, int ticks) {
        this.buffs.put(buff, ticks + 5);
        this.syncBuffs(player);
        this.performBuffs(player);
    }

    public Map<PlayerBuff, Integer> getBuffs() {
        return this.buffs;
    }

    public boolean hasBuff(PlayerBuff buff) {
        return this.buffs.containsKey((Object)buff);
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128379_("onElevator", this.onElevator);
        compound.m_128405_("buffTicks", this.buffTimeout);
        compound.m_128379_("allowFlying", this.allowFlying);
        compound.m_128379_("oldAllowFlying", this.oldAllowFlying);
        int[] buffArray = new int[this.buffs.size()];
        int[] timeoutArray = new int[this.buffs.size()];
        int idx = 0;
        for (Map.Entry<PlayerBuff, Integer> entry : this.buffs.entrySet()) {
            PlayerBuff buff = entry.getKey();
            buffArray[idx] = buff.ordinal();
            timeoutArray[idx] = entry.getValue();
            ++idx;
        }
        compound.m_128385_("buffs", buffArray);
        compound.m_128385_("buffTimeouts", timeoutArray);
    }

    public void loadNBTData(CompoundTag compound) {
        this.onElevator = compound.m_128471_("onElevator");
        this.buffTimeout = compound.m_128451_("buffTicks");
        int[] buffArray = compound.m_128465_("buffs");
        int[] timeoutArray = compound.m_128465_("buffTimeouts");
        this.buffs.clear();
        for (int i = 0; i < buffArray.length; ++i) {
            int buffIdx = buffArray[i];
            this.buffs.put(PlayerBuff.values()[buffIdx], timeoutArray[i]);
        }
        this.allowFlying = compound.m_128471_("allowFlying");
        this.oldAllowFlying = compound.m_128471_("oldAllowFlying");
        this.globalSyncNeeded = true;
    }
}

