/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.render.DERenderTypes;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BinderHandler {
    public static Map<AABB, CCModel> modelCache = new HashMap<AABB, CCModel>();

    public static boolean onBinderUse(Player player, InteractionHand hand, Level world, BlockPos blockClicked, @Nonnull ItemStack binder, Direction sideClicked) {
        BlockEntity tile = world.m_7702_(blockClicked);
        boolean isBound = BinderHandler.isBound(binder);
        if (tile instanceof ICrystalLink && player.m_6144_()) {
            BinderHandler.bind(binder, blockClicked);
            if (world.f_46443_) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.m_237115_((String)"gui.draconicevolution.energy_net.pos_saved_to_tool").m_130940_(ChatFormatting.GREEN), (UUID)TileCrystalBase.MSG_ID);
                player.m_6674_(hand);
            }
            return true;
        }
        if (tile instanceof ICrystalLink && !isBound) {
            ChatHelper.sendIndexed((Player)player, (Component)Component.m_237115_((String)"gui.draconicevolution.energy_net.tool_not_bound").m_130940_(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        if (isBound) {
            BlockPos boundLinkable = BinderHandler.getBound(binder);
            if (boundLinkable.equals((Object)blockClicked)) {
                ChatHelper.sendIndexed((Player)player, (Component)Component.m_237115_((String)"gui.draconicevolution.energy_net.link_to_self").m_130940_(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
                return true;
            }
            BlockEntity boundTile = world.m_7702_(boundLinkable);
            if (boundTile instanceof ICrystalLink) {
                if (((ICrystalLink)boundTile).binderUsed(player, blockClicked, sideClicked)) {
                    player.m_6674_(hand);
                }
            } else {
                ChatHelper.sendIndexed((Player)player, (Component)Component.m_237115_((String)"gui.draconicevolution.energy_net.bound_to_invalid").m_130940_(ChatFormatting.RED), (UUID)TileCrystalBase.MSG_ID);
            }
            return true;
        }
        return false;
    }

    private static boolean isBound(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("draconicevolution:binder", 11);
    }

    private static void bind(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.getCompound((ItemStack)stack).m_128385_("draconicevolution:binder", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    private static BlockPos getBound(ItemStack stack) {
        int[] intArray = stack.m_41783_().m_128465_("draconicevolution:binder");
        return new BlockPos(intArray[0], intArray[1], intArray[2]);
    }

    public static boolean clearBinder(Player player, @Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("draconicevolution:binder")) {
            stack.m_41783_().m_128473_("draconicevolution:binder");
            ChatHelper.sendIndexed((Player)player, (Component)Component.m_237115_((String)"gui.draconicevolution.energy_net.pos_cleared"), (UUID)TileCrystalBase.MSG_ID);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWorldOverlay(LocalPlayer player, PoseStack pStack, Level world, ItemStack stack, Minecraft mc, float partialTicks) {
        if (!BinderHandler.isBound(stack)) {
            return;
        }
        BlockPos pos = BinderHandler.getBound(stack);
        boolean valid = world.m_7702_(pos) instanceof ICrystalLink;
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            shape = Shapes.m_83144_();
        }
        Cuboid6 cuboid6 = new Cuboid6(shape.m_83215_());
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        pStack.m_85836_();
        pStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        pStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        RenderUtils.bufferCuboidSolid((VertexConsumer)new TransformingVertexConsumer(source.m_6299_(DERenderTypes.BOX_NO_DEPTH), pStack), (Cuboid6)cuboid6, (float)(valid ? 0.0f : 1.0f), (float)(valid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        source.m_109911_();
        RenderUtils.bufferCuboidOutline((VertexConsumer)new TransformingVertexConsumer(source.m_6299_(DERenderTypes.OUTLINE_TYPE), pStack), (Cuboid6)cuboid6, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        source.m_109911_();
        pStack.m_85849_();
    }

    private static CCModel modelForAABB(AABB aabb) {
        if (!modelCache.containsKey(aabb)) {
            modelCache.put(aabb, CCModel.newModel((VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)24).generateBlock(0, new Cuboid6(aabb)));
        }
        return modelCache.get(aabb);
    }
}

