/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import com.brandon3055.draconicevolution.DEConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ItemConfigDataHandler {
    public static CompoundTag retrieveData() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_()) {
            ServerLevel world = mc.m_91092_().m_129880_(Level.f_46428_);
            SinglePlayerWorldData data = (SinglePlayerWorldData)world.m_8895_().m_164861_(SinglePlayerWorldData::load, SinglePlayerWorldData::new, SinglePlayerWorldData.FILE_NAME);
            return data.data;
        }
        Path file = Paths.get("./config/brandon3055/servers/" + DEConfig.serverID + ".dat", new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            CompoundTag compoundTag;
            block10: {
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    compoundTag = NbtIo.m_128939_((InputStream)is);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                is.close();
            }
            return compoundTag;
        }
        return new CompoundTag();
    }

    public static void saveData(CompoundTag nbt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_()) {
            ServerLevel world = mc.m_91092_().m_129880_(Level.f_46428_);
            SinglePlayerWorldData data = (SinglePlayerWorldData)world.m_8895_().m_164861_(SinglePlayerWorldData::load, SinglePlayerWorldData::new, SinglePlayerWorldData.FILE_NAME);
            data.data = nbt;
            data.m_77762_();
        } else {
            Path file = Paths.get("./config/brandon3055/servers/" + DEConfig.serverID + ".dat", new String[0]);
            if (Files.notExists(file, new LinkOption[0])) {
                SneakyUtils.sneaky(() -> Files.createDirectories(file.getParent(), new FileAttribute[0]));
            } else {
                SneakyUtils.sneaky(() -> Files.delete(file));
            }
            try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                NbtIo.m_128947_((CompoundTag)nbt, (OutputStream)os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SinglePlayerWorldData
    extends SavedData {
        private static String FILE_NAME = "draconic_item_config";
        private CompoundTag data;

        public SinglePlayerWorldData() {
            this.data = new CompoundTag();
        }

        SinglePlayerWorldData(CompoundTag data) {
            this.data = data;
        }

        public static SinglePlayerWorldData load(CompoundTag nbt) {
            return new SinglePlayerWorldData(nbt);
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            return this.data;
        }
    }
}

